/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.ActiveInstanceRefreshNotFoundException;
import software.amazon.awssdk.services.autoscaling.model.AlreadyExistsException;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingException;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CancelInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.CancelInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshInProgressException;
import software.amazon.awssdk.services.autoscaling.model.InvalidNextTokenException;
import software.amazon.awssdk.services.autoscaling.model.LimitExceededException;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatResponse;
import software.amazon.awssdk.services.autoscaling.model.ResourceContentionException;
import software.amazon.awssdk.services.autoscaling.model.ResourceInUseException;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingActivityInProgressException;
import software.amazon.awssdk.services.autoscaling.model.ServiceLinkedRoleFailureException;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionResponse;
import software.amazon.awssdk.services.autoscaling.model.StartInstanceRefreshRequest;
import software.amazon.awssdk.services.autoscaling.model.StartInstanceRefreshResponse;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsIterable;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsIterable;
import software.amazon.awssdk.services.autoscaling.transform.AttachInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.BatchDeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.BatchPutScheduledUpdateGroupActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CancelInstanceRefreshRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CompleteLifecycleActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateOrUpdateTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteLifecycleHookRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAdjustmentTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingNotificationTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeInstanceRefreshesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLaunchConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLifecycleHookTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLifecycleHooksRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeMetricCollectionTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeNotificationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribePoliciesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScalingActivitiesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScalingProcessTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTerminationPolicyTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DisableMetricsCollectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.EnableMetricsCollectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.EnterStandbyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ExecutePolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ExitStandbyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutLifecycleHookRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutScheduledUpdateGroupActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.RecordLifecycleActionHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ResumeProcessesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetDesiredCapacityRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetInstanceHealthRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetInstanceProtectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.StartInstanceRefreshRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SuspendProcessesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.TerminateInstanceInAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.UpdateAutoScalingGroupRequestMarshaller;

@SdkInternalApi
final class DefaultAutoScalingClient
implements AutoScalingClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAutoScalingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "autoscaling";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachInstancesResponse attachInstances(AttachInstancesRequest attachInstancesRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachInstances");
            AttachInstancesResponse attachInstancesResponse = (AttachInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachInstancesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AttachInstancesRequestMarshaller(this.protocolFactory)));
            return attachInstancesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, attachInstancesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachLoadBalancerTargetGroupsResponse attachLoadBalancerTargetGroups(AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancerTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachLoadBalancerTargetGroups");
            AttachLoadBalancerTargetGroupsResponse attachLoadBalancerTargetGroupsResponse = (AttachLoadBalancerTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerTargetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachLoadBalancerTargetGroupsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AttachLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)));
            return attachLoadBalancerTargetGroupsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, attachLoadBalancerTargetGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachLoadBalancersResponse attachLoadBalancers(AttachLoadBalancersRequest attachLoadBalancersRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachLoadBalancers");
            AttachLoadBalancersResponse attachLoadBalancersResponse = (AttachLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachLoadBalancersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AttachLoadBalancersRequestMarshaller(this.protocolFactory)));
            return attachLoadBalancersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, attachLoadBalancersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteScheduledActionResponse batchDeleteScheduledAction(BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchDeleteScheduledActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteScheduledAction");
            BatchDeleteScheduledActionResponse batchDeleteScheduledActionResponse = (BatchDeleteScheduledActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteScheduledAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDeleteScheduledActionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteScheduledActionRequestMarshaller(this.protocolFactory)));
            return batchDeleteScheduledActionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteScheduledActionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchPutScheduledUpdateGroupActionResponse batchPutScheduledUpdateGroupAction(BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchPutScheduledUpdateGroupActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchPutScheduledUpdateGroupAction");
            BatchPutScheduledUpdateGroupActionResponse batchPutScheduledUpdateGroupActionResponse = (BatchPutScheduledUpdateGroupActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutScheduledUpdateGroupAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchPutScheduledUpdateGroupActionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new BatchPutScheduledUpdateGroupActionRequestMarshaller(this.protocolFactory)));
            return batchPutScheduledUpdateGroupActionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, batchPutScheduledUpdateGroupActionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelInstanceRefreshResponse cancelInstanceRefresh(CancelInstanceRefreshRequest cancelInstanceRefreshRequest) throws LimitExceededException, ResourceContentionException, ActiveInstanceRefreshNotFoundException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CancelInstanceRefreshResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelInstanceRefresh");
            CancelInstanceRefreshResponse cancelInstanceRefreshResponse = (CancelInstanceRefreshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelInstanceRefresh").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelInstanceRefreshRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CancelInstanceRefreshRequestMarshaller(this.protocolFactory)));
            return cancelInstanceRefreshResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, cancelInstanceRefreshRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteLifecycleActionResponse completeLifecycleAction(CompleteLifecycleActionRequest completeLifecycleActionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CompleteLifecycleActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CompleteLifecycleAction");
            CompleteLifecycleActionResponse completeLifecycleActionResponse = (CompleteLifecycleActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteLifecycleAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)completeLifecycleActionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CompleteLifecycleActionRequestMarshaller(this.protocolFactory)));
            return completeLifecycleActionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, completeLifecycleActionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAutoScalingGroupResponse createAutoScalingGroup(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAutoScalingGroup");
            CreateAutoScalingGroupResponse createAutoScalingGroupResponse = (CreateAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAutoScalingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAutoScalingGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateAutoScalingGroupRequestMarshaller(this.protocolFactory)));
            return createAutoScalingGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, createAutoScalingGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLaunchConfigurationResponse createLaunchConfiguration(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLaunchConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLaunchConfiguration");
            CreateLaunchConfigurationResponse createLaunchConfigurationResponse = (CreateLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLaunchConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLaunchConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateLaunchConfigurationRequestMarshaller(this.protocolFactory)));
            return createLaunchConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, createLaunchConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateOrUpdateTagsResponse createOrUpdateTags(CreateOrUpdateTagsRequest createOrUpdateTagsRequest) throws LimitExceededException, AlreadyExistsException, ResourceContentionException, ResourceInUseException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateOrUpdateTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOrUpdateTags");
            CreateOrUpdateTagsResponse createOrUpdateTagsResponse = (CreateOrUpdateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOrUpdateTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrUpdateTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateOrUpdateTagsRequestMarshaller(this.protocolFactory)));
            return createOrUpdateTagsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, createOrUpdateTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAutoScalingGroupResponse deleteAutoScalingGroup(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) throws ScalingActivityInProgressException, ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAutoScalingGroup");
            DeleteAutoScalingGroupResponse deleteAutoScalingGroupResponse = (DeleteAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAutoScalingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAutoScalingGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAutoScalingGroupRequestMarshaller(this.protocolFactory)));
            return deleteAutoScalingGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, deleteAutoScalingGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLaunchConfigurationResponse deleteLaunchConfiguration(DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLaunchConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLaunchConfiguration");
            DeleteLaunchConfigurationResponse deleteLaunchConfigurationResponse = (DeleteLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLaunchConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLaunchConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLaunchConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteLaunchConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, deleteLaunchConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLifecycleHookResponse deleteLifecycleHook(DeleteLifecycleHookRequest deleteLifecycleHookRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLifecycleHookResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLifecycleHook");
            DeleteLifecycleHookResponse deleteLifecycleHookResponse = (DeleteLifecycleHookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLifecycleHook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLifecycleHookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLifecycleHookRequestMarshaller(this.protocolFactory)));
            return deleteLifecycleHookResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, deleteLifecycleHookRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNotificationConfigurationResponse deleteNotificationConfiguration(DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteNotificationConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNotificationConfiguration");
            DeleteNotificationConfigurationResponse deleteNotificationConfigurationResponse = (DeleteNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNotificationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNotificationConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNotificationConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteNotificationConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, deleteNotificationConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeletePolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePolicy");
            DeletePolicyResponse deletePolicyResponse = (DeletePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeletePolicyRequestMarshaller(this.protocolFactory)));
            return deletePolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, deletePolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteScheduledActionResponse deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteScheduledActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScheduledAction");
            DeleteScheduledActionResponse deleteScheduledActionResponse = (DeleteScheduledActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteScheduledActionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteScheduledActionRequestMarshaller(this.protocolFactory)));
            return deleteScheduledActionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, deleteScheduledActionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceContentionException, ResourceInUseException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            DeleteTagsResponse deleteTagsResponse = (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory)));
            return deleteTagsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountLimits");
            DescribeAccountLimitsResponse describeAccountLimitsResponse = (DescribeAccountLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)));
            return describeAccountLimitsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeAccountLimitsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAdjustmentTypesResponse describeAdjustmentTypes(DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAdjustmentTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAdjustmentTypes");
            DescribeAdjustmentTypesResponse describeAdjustmentTypesResponse = (DescribeAdjustmentTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAdjustmentTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAdjustmentTypesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAdjustmentTypesRequestMarshaller(this.protocolFactory)));
            return describeAdjustmentTypesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeAdjustmentTypesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoScalingGroupsResponse describeAutoScalingGroups(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAutoScalingGroups");
            DescribeAutoScalingGroupsResponse describeAutoScalingGroupsResponse = (DescribeAutoScalingGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoScalingGroupsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAutoScalingGroupsRequestMarshaller(this.protocolFactory)));
            return describeAutoScalingGroupsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeAutoScalingGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribeAutoScalingGroupsIterable describeAutoScalingGroupsPaginator(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeAutoScalingGroupsIterable(this, this.applyPaginatorUserAgent(describeAutoScalingGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoScalingInstancesResponse describeAutoScalingInstances(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAutoScalingInstances");
            DescribeAutoScalingInstancesResponse describeAutoScalingInstancesResponse = (DescribeAutoScalingInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoScalingInstancesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAutoScalingInstancesRequestMarshaller(this.protocolFactory)));
            return describeAutoScalingInstancesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeAutoScalingInstancesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribeAutoScalingInstancesIterable describeAutoScalingInstancesPaginator(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeAutoScalingInstancesIterable(this, this.applyPaginatorUserAgent(describeAutoScalingInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoScalingNotificationTypesResponse describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingNotificationTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAutoScalingNotificationTypes");
            DescribeAutoScalingNotificationTypesResponse describeAutoScalingNotificationTypesResponse = (DescribeAutoScalingNotificationTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingNotificationTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoScalingNotificationTypesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAutoScalingNotificationTypesRequestMarshaller(this.protocolFactory)));
            return describeAutoScalingNotificationTypesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeAutoScalingNotificationTypesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInstanceRefreshesResponse describeInstanceRefreshes(DescribeInstanceRefreshesRequest describeInstanceRefreshesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeInstanceRefreshesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInstanceRefreshes");
            DescribeInstanceRefreshesResponse describeInstanceRefreshesResponse = (DescribeInstanceRefreshesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstanceRefreshes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeInstanceRefreshesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInstanceRefreshesRequestMarshaller(this.protocolFactory)));
            return describeInstanceRefreshesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeInstanceRefreshesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLaunchConfigurationsResponse describeLaunchConfigurations(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLaunchConfigurationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLaunchConfigurations");
            DescribeLaunchConfigurationsResponse describeLaunchConfigurationsResponse = (DescribeLaunchConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLaunchConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLaunchConfigurationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLaunchConfigurationsRequestMarshaller(this.protocolFactory)));
            return describeLaunchConfigurationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeLaunchConfigurationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribeLaunchConfigurationsIterable describeLaunchConfigurationsPaginator(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeLaunchConfigurationsIterable(this, this.applyPaginatorUserAgent(describeLaunchConfigurationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLifecycleHookTypesResponse describeLifecycleHookTypes(DescribeLifecycleHookTypesRequest describeLifecycleHookTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLifecycleHookTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLifecycleHookTypes");
            DescribeLifecycleHookTypesResponse describeLifecycleHookTypesResponse = (DescribeLifecycleHookTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLifecycleHookTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLifecycleHookTypesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLifecycleHookTypesRequestMarshaller(this.protocolFactory)));
            return describeLifecycleHookTypesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeLifecycleHookTypesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLifecycleHooksResponse describeLifecycleHooks(DescribeLifecycleHooksRequest describeLifecycleHooksRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLifecycleHooksResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLifecycleHooks");
            DescribeLifecycleHooksResponse describeLifecycleHooksResponse = (DescribeLifecycleHooksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLifecycleHooks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLifecycleHooksRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLifecycleHooksRequestMarshaller(this.protocolFactory)));
            return describeLifecycleHooksResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeLifecycleHooksRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancerTargetGroupsResponse describeLoadBalancerTargetGroups(DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancerTargetGroups");
            DescribeLoadBalancerTargetGroupsResponse describeLoadBalancerTargetGroupsResponse = (DescribeLoadBalancerTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerTargetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerTargetGroupsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)));
            return describeLoadBalancerTargetGroupsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeLoadBalancerTargetGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancers");
            DescribeLoadBalancersResponse describeLoadBalancersResponse = (DescribeLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller(this.protocolFactory)));
            return describeLoadBalancersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeLoadBalancersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetricCollectionTypesResponse describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeMetricCollectionTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetricCollectionTypes");
            DescribeMetricCollectionTypesResponse describeMetricCollectionTypesResponse = (DescribeMetricCollectionTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetricCollectionTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMetricCollectionTypesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMetricCollectionTypesRequestMarshaller(this.protocolFactory)));
            return describeMetricCollectionTypesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeMetricCollectionTypesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNotificationConfigurationsResponse describeNotificationConfigurations(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeNotificationConfigurationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNotificationConfigurations");
            DescribeNotificationConfigurationsResponse describeNotificationConfigurationsResponse = (DescribeNotificationConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNotificationConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNotificationConfigurationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNotificationConfigurationsRequestMarshaller(this.protocolFactory)));
            return describeNotificationConfigurationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeNotificationConfigurationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribeNotificationConfigurationsIterable describeNotificationConfigurationsPaginator(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeNotificationConfigurationsIterable(this, this.applyPaginatorUserAgent(describeNotificationConfigurationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePoliciesResponse describePolicies(DescribePoliciesRequest describePoliciesRequest) throws InvalidNextTokenException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePolicies");
            DescribePoliciesResponse describePoliciesResponse = (DescribePoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePoliciesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribePoliciesRequestMarshaller(this.protocolFactory)));
            return describePoliciesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describePoliciesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribePoliciesIterable describePoliciesPaginator(DescribePoliciesRequest describePoliciesRequest) throws InvalidNextTokenException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribePoliciesIterable(this, this.applyPaginatorUserAgent(describePoliciesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingActivitiesResponse describeScalingActivities(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScalingActivitiesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalingActivities");
            DescribeScalingActivitiesResponse describeScalingActivitiesResponse = (DescribeScalingActivitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingActivities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingActivitiesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScalingActivitiesRequestMarshaller(this.protocolFactory)));
            return describeScalingActivitiesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeScalingActivitiesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribeScalingActivitiesIterable describeScalingActivitiesPaginator(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeScalingActivitiesIterable(this, this.applyPaginatorUserAgent(describeScalingActivitiesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingProcessTypesResponse describeScalingProcessTypes(DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScalingProcessTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalingProcessTypes");
            DescribeScalingProcessTypesResponse describeScalingProcessTypesResponse = (DescribeScalingProcessTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingProcessTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingProcessTypesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScalingProcessTypesRequestMarshaller(this.protocolFactory)));
            return describeScalingProcessTypesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeScalingProcessTypesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScheduledActionsResponse describeScheduledActions(DescribeScheduledActionsRequest describeScheduledActionsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScheduledActionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScheduledActions");
            DescribeScheduledActionsResponse describeScheduledActionsResponse = (DescribeScheduledActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScheduledActionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScheduledActionsRequestMarshaller(this.protocolFactory)));
            return describeScheduledActionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeScheduledActionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribeScheduledActionsIterable describeScheduledActionsPaginator(DescribeScheduledActionsRequest describeScheduledActionsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeScheduledActionsIterable(this, this.applyPaginatorUserAgent(describeScheduledActionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            DescribeTagsResponse describeTagsResponse = (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)));
            return describeTagsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public DescribeTagsIterable describeTagsPaginator(DescribeTagsRequest describeTagsRequest) throws InvalidNextTokenException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        return new DescribeTagsIterable(this, this.applyPaginatorUserAgent(describeTagsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTerminationPolicyTypesResponse describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTerminationPolicyTypesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTerminationPolicyTypes");
            DescribeTerminationPolicyTypesResponse describeTerminationPolicyTypesResponse = (DescribeTerminationPolicyTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTerminationPolicyTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTerminationPolicyTypesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTerminationPolicyTypesRequestMarshaller(this.protocolFactory)));
            return describeTerminationPolicyTypesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, describeTerminationPolicyTypesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachInstancesResponse detachInstances(DetachInstancesRequest detachInstancesRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachInstances");
            DetachInstancesResponse detachInstancesResponse = (DetachInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachInstancesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DetachInstancesRequestMarshaller(this.protocolFactory)));
            return detachInstancesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, detachInstancesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachLoadBalancerTargetGroupsResponse detachLoadBalancerTargetGroups(DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancerTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachLoadBalancerTargetGroups");
            DetachLoadBalancerTargetGroupsResponse detachLoadBalancerTargetGroupsResponse = (DetachLoadBalancerTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancerTargetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachLoadBalancerTargetGroupsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DetachLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)));
            return detachLoadBalancerTargetGroupsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, detachLoadBalancerTargetGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachLoadBalancersResponse detachLoadBalancers(DetachLoadBalancersRequest detachLoadBalancersRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachLoadBalancers");
            DetachLoadBalancersResponse detachLoadBalancersResponse = (DetachLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachLoadBalancersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DetachLoadBalancersRequestMarshaller(this.protocolFactory)));
            return detachLoadBalancersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, detachLoadBalancersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableMetricsCollectionResponse disableMetricsCollection(DisableMetricsCollectionRequest disableMetricsCollectionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableMetricsCollectionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableMetricsCollection");
            DisableMetricsCollectionResponse disableMetricsCollectionResponse = (DisableMetricsCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableMetricsCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableMetricsCollectionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisableMetricsCollectionRequestMarshaller(this.protocolFactory)));
            return disableMetricsCollectionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, disableMetricsCollectionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableMetricsCollectionResponse enableMetricsCollection(EnableMetricsCollectionRequest enableMetricsCollectionRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableMetricsCollectionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableMetricsCollection");
            EnableMetricsCollectionResponse enableMetricsCollectionResponse = (EnableMetricsCollectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableMetricsCollection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableMetricsCollectionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new EnableMetricsCollectionRequestMarshaller(this.protocolFactory)));
            return enableMetricsCollectionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, enableMetricsCollectionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnterStandbyResponse enterStandby(EnterStandbyRequest enterStandbyRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnterStandbyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnterStandby");
            EnterStandbyResponse enterStandbyResponse = (EnterStandbyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnterStandby").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enterStandbyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new EnterStandbyRequestMarshaller(this.protocolFactory)));
            return enterStandbyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, enterStandbyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutePolicyResponse executePolicy(ExecutePolicyRequest executePolicyRequest) throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ExecutePolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecutePolicy");
            ExecutePolicyResponse executePolicyResponse = (ExecutePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecutePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executePolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ExecutePolicyRequestMarshaller(this.protocolFactory)));
            return executePolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, executePolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExitStandbyResponse exitStandby(ExitStandbyRequest exitStandbyRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ExitStandbyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExitStandby");
            ExitStandbyResponse exitStandbyResponse = (ExitStandbyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExitStandby").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exitStandbyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ExitStandbyRequestMarshaller(this.protocolFactory)));
            return exitStandbyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, exitStandbyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutLifecycleHookResponse putLifecycleHook(PutLifecycleHookRequest putLifecycleHookRequest) throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutLifecycleHookResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLifecycleHook");
            PutLifecycleHookResponse putLifecycleHookResponse = (PutLifecycleHookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLifecycleHook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putLifecycleHookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutLifecycleHookRequestMarshaller(this.protocolFactory)));
            return putLifecycleHookResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, putLifecycleHookRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutNotificationConfigurationResponse putNotificationConfiguration(PutNotificationConfigurationRequest putNotificationConfigurationRequest) throws LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutNotificationConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutNotificationConfiguration");
            PutNotificationConfigurationResponse putNotificationConfigurationResponse = (PutNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutNotificationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putNotificationConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutNotificationConfigurationRequestMarshaller(this.protocolFactory)));
            return putNotificationConfigurationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, putNotificationConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutScalingPolicyResponse putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) throws LimitExceededException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutScalingPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutScalingPolicy");
            PutScalingPolicyResponse putScalingPolicyResponse = (PutScalingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScalingPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putScalingPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutScalingPolicyRequestMarshaller(this.protocolFactory)));
            return putScalingPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, putScalingPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutScheduledUpdateGroupActionResponse putScheduledUpdateGroupAction(PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) throws AlreadyExistsException, LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutScheduledUpdateGroupActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutScheduledUpdateGroupAction");
            PutScheduledUpdateGroupActionResponse putScheduledUpdateGroupActionResponse = (PutScheduledUpdateGroupActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScheduledUpdateGroupAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putScheduledUpdateGroupActionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutScheduledUpdateGroupActionRequestMarshaller(this.protocolFactory)));
            return putScheduledUpdateGroupActionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, putScheduledUpdateGroupActionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordLifecycleActionHeartbeatResponse recordLifecycleActionHeartbeat(RecordLifecycleActionHeartbeatRequest recordLifecycleActionHeartbeatRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RecordLifecycleActionHeartbeatResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RecordLifecycleActionHeartbeat");
            RecordLifecycleActionHeartbeatResponse recordLifecycleActionHeartbeatResponse = (RecordLifecycleActionHeartbeatResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RecordLifecycleActionHeartbeat").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)recordLifecycleActionHeartbeatRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RecordLifecycleActionHeartbeatRequestMarshaller(this.protocolFactory)));
            return recordLifecycleActionHeartbeatResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, recordLifecycleActionHeartbeatRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResumeProcessesResponse resumeProcesses(ResumeProcessesRequest resumeProcessesRequest) throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResumeProcessesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResumeProcesses");
            ResumeProcessesResponse resumeProcessesResponse = (ResumeProcessesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeProcesses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resumeProcessesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ResumeProcessesRequestMarshaller(this.protocolFactory)));
            return resumeProcessesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, resumeProcessesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetDesiredCapacityResponse setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest) throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetDesiredCapacityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetDesiredCapacity");
            SetDesiredCapacityResponse setDesiredCapacityResponse = (SetDesiredCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetDesiredCapacity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setDesiredCapacityRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SetDesiredCapacityRequestMarshaller(this.protocolFactory)));
            return setDesiredCapacityResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, setDesiredCapacityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetInstanceHealthResponse setInstanceHealth(SetInstanceHealthRequest setInstanceHealthRequest) throws ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetInstanceHealthResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetInstanceHealth");
            SetInstanceHealthResponse setInstanceHealthResponse = (SetInstanceHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetInstanceHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setInstanceHealthRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SetInstanceHealthRequestMarshaller(this.protocolFactory)));
            return setInstanceHealthResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, setInstanceHealthRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetInstanceProtectionResponse setInstanceProtection(SetInstanceProtectionRequest setInstanceProtectionRequest) throws LimitExceededException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetInstanceProtectionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetInstanceProtection");
            SetInstanceProtectionResponse setInstanceProtectionResponse = (SetInstanceProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetInstanceProtection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setInstanceProtectionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SetInstanceProtectionRequestMarshaller(this.protocolFactory)));
            return setInstanceProtectionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, setInstanceProtectionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartInstanceRefreshResponse startInstanceRefresh(StartInstanceRefreshRequest startInstanceRefreshRequest) throws LimitExceededException, ResourceContentionException, InstanceRefreshInProgressException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StartInstanceRefreshResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartInstanceRefresh");
            StartInstanceRefreshResponse startInstanceRefreshResponse = (StartInstanceRefreshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartInstanceRefresh").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startInstanceRefreshRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartInstanceRefreshRequestMarshaller(this.protocolFactory)));
            return startInstanceRefreshResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, startInstanceRefreshRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SuspendProcessesResponse suspendProcesses(SuspendProcessesRequest suspendProcessesRequest) throws ResourceInUseException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SuspendProcessesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SuspendProcesses");
            SuspendProcessesResponse suspendProcessesResponse = (SuspendProcessesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SuspendProcesses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)suspendProcessesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SuspendProcessesRequestMarshaller(this.protocolFactory)));
            return suspendProcessesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, suspendProcessesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateInstanceInAutoScalingGroupResponse terminateInstanceInAutoScalingGroup(TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) throws ScalingActivityInProgressException, ResourceContentionException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TerminateInstanceInAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateInstanceInAutoScalingGroup");
            TerminateInstanceInAutoScalingGroupResponse terminateInstanceInAutoScalingGroupResponse = (TerminateInstanceInAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateInstanceInAutoScalingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateInstanceInAutoScalingGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TerminateInstanceInAutoScalingGroupRequestMarshaller(this.protocolFactory)));
            return terminateInstanceInAutoScalingGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, terminateInstanceInAutoScalingGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAutoScalingGroupResponse updateAutoScalingGroup(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) throws ScalingActivityInProgressException, ResourceContentionException, ServiceLinkedRoleFailureException, AwsServiceException, SdkClientException, AutoScalingException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateAutoScalingGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAutoScalingGroup");
            UpdateAutoScalingGroupResponse updateAutoScalingGroupResponse = (UpdateAutoScalingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAutoScalingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAutoScalingGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAutoScalingGroupRequestMarshaller(this.protocolFactory)));
            return updateAutoScalingGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAutoScalingClient.resolveMetricPublishers(this.clientConfiguration, updateAutoScalingGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUse").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InstanceRefreshInProgress").exceptionBuilderSupplier(InstanceRefreshInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScalingActivityInProgress").exceptionBuilderSupplier(ScalingActivityInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextToken").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceeded").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExists").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActiveInstanceRefreshNotFound").exceptionBuilderSupplier(ActiveInstanceRefreshNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceContention").exceptionBuilderSupplier(ResourceContentionException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleFailure").exceptionBuilderSupplier(ServiceLinkedRoleFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AutoScalingException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends AutoScalingRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.55").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AutoScalingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

