/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.TerminationPoliciesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTerminationPolicyTypesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeTerminationPolicyTypesResponse> {
    private static final SdkField<List<String>> TERMINATION_POLICY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTerminationPolicyTypesResponse.getter(DescribeTerminationPolicyTypesResponse::terminationPolicyTypes)).setter(DescribeTerminationPolicyTypesResponse.setter(Builder::terminationPolicyTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicyTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINATION_POLICY_TYPES_FIELD));
    private final List<String> terminationPolicyTypes;

    private DescribeTerminationPolicyTypesResponse(BuilderImpl builder) {
        super(builder);
        this.terminationPolicyTypes = builder.terminationPolicyTypes;
    }

    public boolean hasTerminationPolicyTypes() {
        return this.terminationPolicyTypes != null && !(this.terminationPolicyTypes instanceof SdkAutoConstructList);
    }

    public List<String> terminationPolicyTypes() {
        return this.terminationPolicyTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationPolicyTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTerminationPolicyTypesResponse)) {
            return false;
        }
        DescribeTerminationPolicyTypesResponse other = (DescribeTerminationPolicyTypesResponse)((Object)obj);
        return Objects.equals(this.terminationPolicyTypes(), other.terminationPolicyTypes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTerminationPolicyTypesResponse").add("TerminationPolicyTypes", this.terminationPolicyTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TerminationPolicyTypes": {
                return Optional.ofNullable(clazz.cast(this.terminationPolicyTypes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTerminationPolicyTypesResponse, T> g) {
        return obj -> g.apply((DescribeTerminationPolicyTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<String> terminationPolicyTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTerminationPolicyTypesResponse model) {
            super(model);
            this.terminationPolicyTypes(model.terminationPolicyTypes);
        }

        public final Collection<String> getTerminationPolicyTypes() {
            return this.terminationPolicyTypes;
        }

        @Override
        public final Builder terminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicyTypes(String ... terminationPolicyTypes) {
            this.terminationPolicyTypes(Arrays.asList(terminationPolicyTypes));
            return this;
        }

        public final void setTerminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
        }

        @Override
        public DescribeTerminationPolicyTypesResponse build() {
            return new DescribeTerminationPolicyTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTerminationPolicyTypesResponse> {
        public Builder terminationPolicyTypes(Collection<String> var1);

        public Builder terminationPolicyTypes(String ... var1);
    }
}

