/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetDesiredCapacityRequest extends AutoScalingRequest implements
        ToCopyableBuilder<SetDesiredCapacityRequest.Builder, SetDesiredCapacityRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetDesiredCapacityRequest::autoScalingGroupName)).setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SetDesiredCapacityRequest::desiredCapacity)).setter(setter(Builder::desiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()).build();

    private static final SdkField<Boolean> HONOR_COOLDOWN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SetDesiredCapacityRequest::honorCooldown)).setter(setter(Builder::honorCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HonorCooldown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            DESIRED_CAPACITY_FIELD, HONOR_COOLDOWN_FIELD));

    private final String autoScalingGroupName;

    private final Integer desiredCapacity;

    private final Boolean honorCooldown;

    private SetDesiredCapacityRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.desiredCapacity = builder.desiredCapacity;
        this.honorCooldown = builder.honorCooldown;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the
     * capacity it attempts to maintain.
     * </p>
     * 
     * @return The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and
     *         the capacity it attempts to maintain.
     */
    public Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before initiating a scaling
     * activity to set your Auto Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling does not honor
     * the cooldown period during manual scaling activities.
     * </p>
     * 
     * @return Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before initiating a
     *         scaling activity to set your Auto Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling
     *         does not honor the cooldown period during manual scaling activities.
     */
    public Boolean honorCooldown() {
        return honorCooldown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(honorCooldown());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDesiredCapacityRequest)) {
            return false;
        }
        SetDesiredCapacityRequest other = (SetDesiredCapacityRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(desiredCapacity(), other.desiredCapacity())
                && Objects.equals(honorCooldown(), other.honorCooldown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetDesiredCapacityRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("DesiredCapacity", desiredCapacity()).add("HonorCooldown", honorCooldown()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "DesiredCapacity":
            return Optional.ofNullable(clazz.cast(desiredCapacity()));
        case "HonorCooldown":
            return Optional.ofNullable(clazz.cast(honorCooldown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetDesiredCapacityRequest, T> g) {
        return obj -> g.apply((SetDesiredCapacityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetDesiredCapacityRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the
         * capacity it attempts to maintain.
         * </p>
         * 
         * @param desiredCapacity
         *        The desired capacity is the initial capacity of the Auto Scaling group after this operation completes
         *        and the capacity it attempts to maintain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before initiating a
         * scaling activity to set your Auto Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling does
         * not honor the cooldown period during manual scaling activities.
         * </p>
         * 
         * @param honorCooldown
         *        Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before initiating
         *        a scaling activity to set your Auto Scaling group to its new capacity. By default, Amazon EC2 Auto
         *        Scaling does not honor the cooldown period during manual scaling activities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honorCooldown(Boolean honorCooldown);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private Integer desiredCapacity;

        private Boolean honorCooldown;

        private BuilderImpl() {
        }

        private BuilderImpl(SetDesiredCapacityRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            desiredCapacity(model.desiredCapacity);
            honorCooldown(model.honorCooldown);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Boolean getHonorCooldown() {
            return honorCooldown;
        }

        @Override
        public final Builder honorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
            return this;
        }

        public final void setHonorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetDesiredCapacityRequest build() {
            return new SetDesiredCapacityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
