/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutNotificationConfigurationRequest extends AutoScalingRequest implements
        ToCopyableBuilder<PutNotificationConfigurationRequest.Builder, PutNotificationConfigurationRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutNotificationConfigurationRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutNotificationConfigurationRequest::topicARN)).setter(setter(Builder::topicARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicARN").build()).build();

    private static final SdkField<List<String>> NOTIFICATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PutNotificationConfigurationRequest::notificationTypes))
            .setter(setter(Builder::notificationTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            TOPIC_ARN_FIELD, NOTIFICATION_TYPES_FIELD));

    private final String autoScalingGroupName;

    private final String topicARN;

    private final List<String> notificationTypes;

    private PutNotificationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
        this.notificationTypes = builder.notificationTypes;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS) topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS) topic.
     */
    public String topicARN() {
        return topicARN;
    }

    /**
     * Returns true if the NotificationTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNotificationTypes() {
        return notificationTypes != null && !(notificationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of event that causes the notification to be sent. To query the notification types supported by Amazon
     * EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotificationTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type of event that causes the notification to be sent. To query the notification types supported by
     *         Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
     */
    public List<String> notificationTypes() {
        return notificationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(topicARN());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutNotificationConfigurationRequest)) {
            return false;
        }
        PutNotificationConfigurationRequest other = (PutNotificationConfigurationRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(topicARN(), other.topicARN()) && Objects.equals(notificationTypes(), other.notificationTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutNotificationConfigurationRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("TopicARN", topicARN()).add("NotificationTypes", notificationTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "TopicARN":
            return Optional.ofNullable(clazz.cast(topicARN()));
        case "NotificationTypes":
            return Optional.ofNullable(clazz.cast(notificationTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutNotificationConfigurationRequest, T> g) {
        return obj -> g.apply((PutNotificationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutNotificationConfigurationRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS) topic.
         * </p>
         * 
         * @param topicARN
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS) topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicARN(String topicARN);

        /**
         * <p>
         * The type of event that causes the notification to be sent. To query the notification types supported by
         * Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
         * </p>
         * 
         * @param notificationTypes
         *        The type of event that causes the notification to be sent. To query the notification types supported
         *        by Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTypes(Collection<String> notificationTypes);

        /**
         * <p>
         * The type of event that causes the notification to be sent. To query the notification types supported by
         * Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
         * </p>
         * 
         * @param notificationTypes
         *        The type of event that causes the notification to be sent. To query the notification types supported
         *        by Amazon EC2 Auto Scaling, call the <a>DescribeAutoScalingNotificationTypes</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTypes(String... notificationTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String topicARN;

        private List<String> notificationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutNotificationConfigurationRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            topicARN(model.topicARN);
            notificationTypes(model.notificationTypes);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getTopicARN() {
            return topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        public final Collection<String> getNotificationTypes() {
            return notificationTypes;
        }

        @Override
        public final Builder notificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTypes(String... notificationTypes) {
            notificationTypes(Arrays.asList(notificationTypes));
            return this;
        }

        public final void setNotificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutNotificationConfigurationRequest build() {
            return new PutNotificationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
