/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an automatic scaling process that has been suspended. For more information, see <a>ProcessType</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuspendedProcess implements SdkPojo, Serializable,
        ToCopyableBuilder<SuspendedProcess.Builder, SuspendedProcess> {
    private static final SdkField<String> PROCESS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SuspendedProcess::processName)).setter(setter(Builder::processName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessName").build()).build();

    private static final SdkField<String> SUSPENSION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SuspendedProcess::suspensionReason)).setter(setter(Builder::suspensionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspensionReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESS_NAME_FIELD,
            SUSPENSION_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String processName;

    private final String suspensionReason;

    private SuspendedProcess(BuilderImpl builder) {
        this.processName = builder.processName;
        this.suspensionReason = builder.suspensionReason;
    }

    /**
     * <p>
     * The name of the suspended process.
     * </p>
     * 
     * @return The name of the suspended process.
     */
    public String processName() {
        return processName;
    }

    /**
     * <p>
     * The reason that the process was suspended.
     * </p>
     * 
     * @return The reason that the process was suspended.
     */
    public String suspensionReason() {
        return suspensionReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(processName());
        hashCode = 31 * hashCode + Objects.hashCode(suspensionReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendedProcess)) {
            return false;
        }
        SuspendedProcess other = (SuspendedProcess) obj;
        return Objects.equals(processName(), other.processName()) && Objects.equals(suspensionReason(), other.suspensionReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SuspendedProcess").add("ProcessName", processName()).add("SuspensionReason", suspensionReason())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessName":
            return Optional.ofNullable(clazz.cast(processName()));
        case "SuspensionReason":
            return Optional.ofNullable(clazz.cast(suspensionReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuspendedProcess, T> g) {
        return obj -> g.apply((SuspendedProcess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuspendedProcess> {
        /**
         * <p>
         * The name of the suspended process.
         * </p>
         * 
         * @param processName
         *        The name of the suspended process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processName(String processName);

        /**
         * <p>
         * The reason that the process was suspended.
         * </p>
         * 
         * @param suspensionReason
         *        The reason that the process was suspended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suspensionReason(String suspensionReason);
    }

    static final class BuilderImpl implements Builder {
        private String processName;

        private String suspensionReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendedProcess model) {
            processName(model.processName);
            suspensionReason(model.suspensionReason);
        }

        public final String getProcessName() {
            return processName;
        }

        @Override
        public final Builder processName(String processName) {
            this.processName = processName;
            return this;
        }

        public final void setProcessName(String processName) {
            this.processName = processName;
        }

        public final String getSuspensionReason() {
            return suspensionReason;
        }

        @Override
        public final Builder suspensionReason(String suspensionReason) {
            this.suspensionReason = suspensionReason;
            return this;
        }

        public final void setSuspensionReason(String suspensionReason) {
            this.suspensionReason = suspensionReason;
        }

        @Override
        public SuspendedProcess build() {
            return new SuspendedProcess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
