/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompleteLifecycleActionRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, CompleteLifecycleActionRequest> {
    private static final SdkField<String> LIFECYCLE_HOOK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompleteLifecycleActionRequest.getter(CompleteLifecycleActionRequest::lifecycleHookName)).setter(CompleteLifecycleActionRequest.setter(Builder::lifecycleHookName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookName").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompleteLifecycleActionRequest.getter(CompleteLifecycleActionRequest::autoScalingGroupName)).setter(CompleteLifecycleActionRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> LIFECYCLE_ACTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompleteLifecycleActionRequest.getter(CompleteLifecycleActionRequest::lifecycleActionToken)).setter(CompleteLifecycleActionRequest.setter(Builder::lifecycleActionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleActionToken").build()}).build();
    private static final SdkField<String> LIFECYCLE_ACTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompleteLifecycleActionRequest.getter(CompleteLifecycleActionRequest::lifecycleActionResult)).setter(CompleteLifecycleActionRequest.setter(Builder::lifecycleActionResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleActionResult").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompleteLifecycleActionRequest.getter(CompleteLifecycleActionRequest::instanceId)).setter(CompleteLifecycleActionRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOK_NAME_FIELD, AUTO_SCALING_GROUP_NAME_FIELD, LIFECYCLE_ACTION_TOKEN_FIELD, LIFECYCLE_ACTION_RESULT_FIELD, INSTANCE_ID_FIELD));
    private final String lifecycleHookName;
    private final String autoScalingGroupName;
    private final String lifecycleActionToken;
    private final String lifecycleActionResult;
    private final String instanceId;

    private CompleteLifecycleActionRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleActionToken = builder.lifecycleActionToken;
        this.lifecycleActionResult = builder.lifecycleActionResult;
        this.instanceId = builder.instanceId;
    }

    public String lifecycleHookName() {
        return this.lifecycleHookName;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String lifecycleActionToken() {
        return this.lifecycleActionToken;
    }

    public String lifecycleActionResult() {
        return this.lifecycleActionResult;
    }

    public String instanceId() {
        return this.instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleActionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleActionResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteLifecycleActionRequest)) {
            return false;
        }
        CompleteLifecycleActionRequest other = (CompleteLifecycleActionRequest)((Object)obj);
        return Objects.equals(this.lifecycleHookName(), other.lifecycleHookName()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.lifecycleActionToken(), other.lifecycleActionToken()) && Objects.equals(this.lifecycleActionResult(), other.lifecycleActionResult()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public String toString() {
        return ToString.builder((String)"CompleteLifecycleActionRequest").add("LifecycleHookName", (Object)this.lifecycleHookName()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("LifecycleActionToken", (Object)this.lifecycleActionToken()).add("LifecycleActionResult", (Object)this.lifecycleActionResult()).add("InstanceId", (Object)this.instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHookName": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHookName()));
            }
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "LifecycleActionToken": {
                return Optional.ofNullable(clazz.cast(this.lifecycleActionToken()));
            }
            case "LifecycleActionResult": {
                return Optional.ofNullable(clazz.cast(this.lifecycleActionResult()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompleteLifecycleActionRequest, T> g) {
        return obj -> g.apply((CompleteLifecycleActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String lifecycleHookName;
        private String autoScalingGroupName;
        private String lifecycleActionToken;
        private String lifecycleActionResult;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteLifecycleActionRequest model) {
            super(model);
            this.lifecycleHookName(model.lifecycleHookName);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.lifecycleActionToken(model.lifecycleActionToken);
            this.lifecycleActionResult(model.lifecycleActionResult);
            this.instanceId(model.instanceId);
        }

        public final String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLifecycleActionToken() {
            return this.lifecycleActionToken;
        }

        @Override
        public final Builder lifecycleActionToken(String lifecycleActionToken) {
            this.lifecycleActionToken = lifecycleActionToken;
            return this;
        }

        public final void setLifecycleActionToken(String lifecycleActionToken) {
            this.lifecycleActionToken = lifecycleActionToken;
        }

        public final String getLifecycleActionResult() {
            return this.lifecycleActionResult;
        }

        @Override
        public final Builder lifecycleActionResult(String lifecycleActionResult) {
            this.lifecycleActionResult = lifecycleActionResult;
            return this;
        }

        public final void setLifecycleActionResult(String lifecycleActionResult) {
            this.lifecycleActionResult = lifecycleActionResult;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteLifecycleActionRequest build() {
            return new CompleteLifecycleActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompleteLifecycleActionRequest> {
        public Builder lifecycleHookName(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder lifecycleActionToken(String var1);

        public Builder lifecycleActionResult(String var1);

        public Builder instanceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

