/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMappingsCopier;
import software.amazon.awssdk.services.autoscaling.model.ClassicLinkVPCSecurityGroupsCopier;
import software.amazon.awssdk.services.autoscaling.model.InstanceMonitoring;
import software.amazon.awssdk.services.autoscaling.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLaunchConfigurationRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, CreateLaunchConfigurationRequest> {
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::launchConfigurationName)).setter(CreateLaunchConfigurationRequest.setter(Builder::launchConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::imageId)).setter(CreateLaunchConfigurationRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::keyName)).setter(CreateLaunchConfigurationRequest.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::securityGroups)).setter(CreateLaunchConfigurationRequest.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLASSIC_LINK_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::classicLinkVPCId)).setter(CreateLaunchConfigurationRequest.setter(Builder::classicLinkVPCId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVPCId").build()}).build();
    private static final SdkField<List<String>> CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::classicLinkVPCSecurityGroups)).setter(CreateLaunchConfigurationRequest.setter(Builder::classicLinkVPCSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVPCSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::userData)).setter(CreateLaunchConfigurationRequest.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::instanceId)).setter(CreateLaunchConfigurationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::instanceType)).setter(CreateLaunchConfigurationRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::kernelId)).setter(CreateLaunchConfigurationRequest.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::ramdiskId)).setter(CreateLaunchConfigurationRequest.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").build()}).build();
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::blockDeviceMappings)).setter(CreateLaunchConfigurationRequest.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceMonitoring> INSTANCE_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::instanceMonitoring)).setter(CreateLaunchConfigurationRequest.setter(Builder::instanceMonitoring)).constructor(InstanceMonitoring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMonitoring").build()}).build();
    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::spotPrice)).setter(CreateLaunchConfigurationRequest.setter(Builder::spotPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").build()}).build();
    private static final SdkField<String> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::iamInstanceProfile)).setter(CreateLaunchConfigurationRequest.setter(Builder::iamInstanceProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::ebsOptimized)).setter(CreateLaunchConfigurationRequest.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::associatePublicIpAddress)).setter(CreateLaunchConfigurationRequest.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build()}).build();
    private static final SdkField<String> PLACEMENT_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLaunchConfigurationRequest.getter(CreateLaunchConfigurationRequest::placementTenancy)).setter(CreateLaunchConfigurationRequest.setter(Builder::placementTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementTenancy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_CONFIGURATION_NAME_FIELD, IMAGE_ID_FIELD, KEY_NAME_FIELD, SECURITY_GROUPS_FIELD, CLASSIC_LINK_VPC_ID_FIELD, CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD, USER_DATA_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, RAMDISK_ID_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, INSTANCE_MONITORING_FIELD, SPOT_PRICE_FIELD, IAM_INSTANCE_PROFILE_FIELD, EBS_OPTIMIZED_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, PLACEMENT_TENANCY_FIELD));
    private final String launchConfigurationName;
    private final String imageId;
    private final String keyName;
    private final List<String> securityGroups;
    private final String classicLinkVPCId;
    private final List<String> classicLinkVPCSecurityGroups;
    private final String userData;
    private final String instanceId;
    private final String instanceType;
    private final String kernelId;
    private final String ramdiskId;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final InstanceMonitoring instanceMonitoring;
    private final String spotPrice;
    private final String iamInstanceProfile;
    private final Boolean ebsOptimized;
    private final Boolean associatePublicIpAddress;
    private final String placementTenancy;

    private CreateLaunchConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.launchConfigurationName = builder.launchConfigurationName;
        this.imageId = builder.imageId;
        this.keyName = builder.keyName;
        this.securityGroups = builder.securityGroups;
        this.classicLinkVPCId = builder.classicLinkVPCId;
        this.classicLinkVPCSecurityGroups = builder.classicLinkVPCSecurityGroups;
        this.userData = builder.userData;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.instanceMonitoring = builder.instanceMonitoring;
        this.spotPrice = builder.spotPrice;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.ebsOptimized = builder.ebsOptimized;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.placementTenancy = builder.placementTenancy;
    }

    public String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public String imageId() {
        return this.imageId;
    }

    public String keyName() {
        return this.keyName;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public String classicLinkVPCId() {
        return this.classicLinkVPCId;
    }

    public List<String> classicLinkVPCSecurityGroups() {
        return this.classicLinkVPCSecurityGroups;
    }

    public String userData() {
        return this.userData;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public InstanceMonitoring instanceMonitoring() {
        return this.instanceMonitoring;
    }

    public String spotPrice() {
        return this.spotPrice;
    }

    public String iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public String placementTenancy() {
        return this.placementTenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.classicLinkVPCId());
        hashCode = 31 * hashCode + Objects.hashCode(this.classicLinkVPCSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementTenancy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchConfigurationRequest)) {
            return false;
        }
        CreateLaunchConfigurationRequest other = (CreateLaunchConfigurationRequest)((Object)obj);
        return Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.classicLinkVPCId(), other.classicLinkVPCId()) && Objects.equals(this.classicLinkVPCSecurityGroups(), other.classicLinkVPCSecurityGroups()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.instanceMonitoring(), other.instanceMonitoring()) && Objects.equals(this.spotPrice(), other.spotPrice()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.placementTenancy(), other.placementTenancy());
    }

    public String toString() {
        return ToString.builder((String)"CreateLaunchConfigurationRequest").add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("ImageId", (Object)this.imageId()).add("KeyName", (Object)this.keyName()).add("SecurityGroups", this.securityGroups()).add("ClassicLinkVPCId", (Object)this.classicLinkVPCId()).add("ClassicLinkVPCSecurityGroups", this.classicLinkVPCSecurityGroups()).add("UserData", (Object)this.userData()).add("InstanceId", (Object)this.instanceId()).add("InstanceType", (Object)this.instanceType()).add("KernelId", (Object)this.kernelId()).add("RamdiskId", (Object)this.ramdiskId()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("InstanceMonitoring", (Object)this.instanceMonitoring()).add("SpotPrice", (Object)this.spotPrice()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("EbsOptimized", (Object)this.ebsOptimized()).add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("PlacementTenancy", (Object)this.placementTenancy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationName()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "ClassicLinkVPCId": {
                return Optional.ofNullable(clazz.cast(this.classicLinkVPCId()));
            }
            case "ClassicLinkVPCSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.classicLinkVPCSecurityGroups()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "InstanceMonitoring": {
                return Optional.ofNullable(clazz.cast(this.instanceMonitoring()));
            }
            case "SpotPrice": {
                return Optional.ofNullable(clazz.cast(this.spotPrice()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "AssociatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "PlacementTenancy": {
                return Optional.ofNullable(clazz.cast(this.placementTenancy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchConfigurationRequest, T> g) {
        return obj -> g.apply((CreateLaunchConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String launchConfigurationName;
        private String imageId;
        private String keyName;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String classicLinkVPCId;
        private List<String> classicLinkVPCSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String userData;
        private String instanceId;
        private String instanceType;
        private String kernelId;
        private String ramdiskId;
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private InstanceMonitoring instanceMonitoring;
        private String spotPrice;
        private String iamInstanceProfile;
        private Boolean ebsOptimized;
        private Boolean associatePublicIpAddress;
        private String placementTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchConfigurationRequest model) {
            super(model);
            this.launchConfigurationName(model.launchConfigurationName);
            this.imageId(model.imageId);
            this.keyName(model.keyName);
            this.securityGroups(model.securityGroups);
            this.classicLinkVPCId(model.classicLinkVPCId);
            this.classicLinkVPCSecurityGroups(model.classicLinkVPCSecurityGroups);
            this.userData(model.userData);
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.ramdiskId(model.ramdiskId);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.instanceMonitoring(model.instanceMonitoring);
            this.spotPrice(model.spotPrice);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.ebsOptimized(model.ebsOptimized);
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.placementTenancy(model.placementTenancy);
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getClassicLinkVPCId() {
            return this.classicLinkVPCId;
        }

        @Override
        public final Builder classicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
            return this;
        }

        public final void setClassicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
        }

        public final Collection<String> getClassicLinkVPCSecurityGroups() {
            return this.classicLinkVPCSecurityGroups;
        }

        @Override
        public final Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLinkVPCSecurityGroups(String ... classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups(Arrays.asList(classicLinkVPCSecurityGroups));
            return this;
        }

        public final void setClassicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final InstanceMonitoring.Builder getInstanceMonitoring() {
            return this.instanceMonitoring != null ? this.instanceMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder instanceMonitoring(InstanceMonitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public final void setInstanceMonitoring(InstanceMonitoring.BuilderImpl instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring != null ? instanceMonitoring.build() : null;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final String getPlacementTenancy() {
            return this.placementTenancy;
        }

        @Override
        public final Builder placementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        public final void setPlacementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchConfigurationRequest build() {
            return new CreateLaunchConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLaunchConfigurationRequest> {
        public Builder launchConfigurationName(String var1);

        public Builder imageId(String var1);

        public Builder keyName(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder classicLinkVPCId(String var1);

        public Builder classicLinkVPCSecurityGroups(Collection<String> var1);

        public Builder classicLinkVPCSecurityGroups(String ... var1);

        public Builder userData(String var1);

        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder kernelId(String var1);

        public Builder ramdiskId(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder instanceMonitoring(InstanceMonitoring var1);

        default public Builder instanceMonitoring(Consumer<InstanceMonitoring.Builder> instanceMonitoring) {
            return this.instanceMonitoring((InstanceMonitoring)((InstanceMonitoring.Builder)InstanceMonitoring.builder().applyMutation(instanceMonitoring)).build());
        }

        public Builder spotPrice(String var1);

        public Builder iamInstanceProfile(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder associatePublicIpAddress(Boolean var1);

        public Builder placementTenancy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

