/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;

public class SetDesiredCapacityRequestMarshaller
implements Marshaller<Request<SetDesiredCapacityRequest>, SetDesiredCapacityRequest> {
    public Request<SetDesiredCapacityRequest> marshall(SetDesiredCapacityRequest setDesiredCapacityRequest) {
        if (setDesiredCapacityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)setDesiredCapacityRequest, "AutoScalingClient");
        request.addParameter("Action", "SetDesiredCapacity");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setDesiredCapacityRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)setDesiredCapacityRequest.autoScalingGroupName()));
        }
        if (setDesiredCapacityRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)setDesiredCapacityRequest.desiredCapacity()));
        }
        if (setDesiredCapacityRequest.honorCooldown() != null) {
            request.addParameter("HonorCooldown", StringUtils.fromBoolean((Boolean)setDesiredCapacityRequest.honorCooldown()));
        }
        return request;
    }
}

