/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest;

public class DeletePolicyRequestMarshaller
implements Marshaller<Request<DeletePolicyRequest>, DeletePolicyRequest> {
    public Request<DeletePolicyRequest> marshall(DeletePolicyRequest deletePolicyRequest) {
        if (deletePolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deletePolicyRequest, "AutoScalingClient");
        request.addParameter("Action", "DeletePolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deletePolicyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)deletePolicyRequest.autoScalingGroupName()));
        }
        if (deletePolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)deletePolicyRequest.policyName()));
        }
        return request;
    }
}

