/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;

public class AttachLoadBalancerTargetGroupsRequestMarshaller
implements Marshaller<Request<AttachLoadBalancerTargetGroupsRequest>, AttachLoadBalancerTargetGroupsRequest> {
    public Request<AttachLoadBalancerTargetGroupsRequest> marshall(AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) {
        List<String> targetGroupARNsList;
        if (attachLoadBalancerTargetGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)attachLoadBalancerTargetGroupsRequest, "AutoScalingClient");
        request.addParameter("Action", "AttachLoadBalancerTargetGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachLoadBalancerTargetGroupsRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)attachLoadBalancerTargetGroupsRequest.autoScalingGroupName()));
        }
        if ((targetGroupARNsList = attachLoadBalancerTargetGroupsRequest.targetGroupARNs()) != null) {
            if (!targetGroupARNsList.isEmpty()) {
                int targetGroupARNsListIndex = 1;
                for (String targetGroupARNsListValue : targetGroupARNsList) {
                    if (targetGroupARNsListValue != null) {
                        request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex, StringUtils.fromString((String)targetGroupARNsListValue));
                    }
                    ++targetGroupARNsListIndex;
                }
            } else {
                request.addParameter("TargetGroupARNs", "");
            }
        }
        return request;
    }
}

