/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.NotificationConfiguration;

public class DescribeNotificationConfigurationsPublisher
implements SdkPublisher<DescribeNotificationConfigurationsResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeNotificationConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNotificationConfigurationsPublisher(AutoScalingAsyncClient client, DescribeNotificationConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNotificationConfigurationsPublisher(AutoScalingAsyncClient client, DescribeNotificationConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNotificationConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNotificationConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<NotificationConfiguration> notificationConfigurations() {
        Function<DescribeNotificationConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationConfigurations() != null) {
                return response.notificationConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeNotificationConfigurationsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeNotificationConfigurationsPublisher resume(DescribeNotificationConfigurationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeNotificationConfigurationsPublisher(this.client, (DescribeNotificationConfigurationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeNotificationConfigurationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeNotificationConfigurationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeNotificationConfigurationsResponseFetcher
    implements AsyncPageFetcher<DescribeNotificationConfigurationsResponse> {
        private DescribeNotificationConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNotificationConfigurationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeNotificationConfigurationsResponse> nextPage(DescribeNotificationConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNotificationConfigurationsPublisher.this.client.describeNotificationConfigurations(DescribeNotificationConfigurationsPublisher.this.firstRequest);
            }
            return DescribeNotificationConfigurationsPublisher.this.client.describeNotificationConfigurations((DescribeNotificationConfigurationsRequest)((Object)DescribeNotificationConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

