/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;

public class DescribeAutoScalingGroupsIterable
implements SdkIterable<DescribeAutoScalingGroupsResponse> {
    private final AutoScalingClient client;
    private final DescribeAutoScalingGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAutoScalingGroupsIterable(AutoScalingClient client, DescribeAutoScalingGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAutoScalingGroupsResponseFetcher();
    }

    public Iterator<DescribeAutoScalingGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<AutoScalingGroup> autoScalingGroups() {
        Function<DescribeAutoScalingGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.autoScalingGroups() != null) {
                return response.autoScalingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeAutoScalingGroupsIterable resume(DescribeAutoScalingGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAutoScalingGroupsIterable(this.client, (DescribeAutoScalingGroupsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAutoScalingGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeAutoScalingGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeAutoScalingGroupsResponseFetcher
    implements SyncPageFetcher<DescribeAutoScalingGroupsResponse> {
        private DescribeAutoScalingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutoScalingGroupsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeAutoScalingGroupsResponse nextPage(DescribeAutoScalingGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutoScalingGroupsIterable.this.client.describeAutoScalingGroups(DescribeAutoScalingGroupsIterable.this.firstRequest);
            }
            return DescribeAutoScalingGroupsIterable.this.client.describeAutoScalingGroups((DescribeAutoScalingGroupsRequest)((Object)DescribeAutoScalingGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

