/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest;

public class SetInstanceProtectionRequestMarshaller
implements Marshaller<Request<SetInstanceProtectionRequest>, SetInstanceProtectionRequest> {
    public Request<SetInstanceProtectionRequest> marshall(SetInstanceProtectionRequest setInstanceProtectionRequest) {
        if (setInstanceProtectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)setInstanceProtectionRequest, "AutoScalingClient");
        request.addParameter("Action", "SetInstanceProtection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> instanceIdsList = setInstanceProtectionRequest.instanceIds();
        if (instanceIdsList != null) {
            if (!instanceIdsList.isEmpty()) {
                int instanceIdsListIndex = 1;
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue != null) {
                        request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString((String)instanceIdsListValue));
                    }
                    ++instanceIdsListIndex;
                }
            } else {
                request.addParameter("InstanceIds", "");
            }
        }
        if (setInstanceProtectionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)setInstanceProtectionRequest.autoScalingGroupName()));
        }
        if (setInstanceProtectionRequest.protectedFromScaleIn() != null) {
            request.addParameter("ProtectedFromScaleIn", StringUtils.fromBoolean((Boolean)setInstanceProtectionRequest.protectedFromScaleIn()));
        }
        return request;
    }
}

