/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingInstanceDetails;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;

public final class DescribeAutoScalingInstancesPaginator
implements SdkIterable<DescribeAutoScalingInstancesResponse> {
    private final AutoScalingClient client;
    private final DescribeAutoScalingInstancesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeAutoScalingInstancesPaginator(AutoScalingClient client, DescribeAutoScalingInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAutoScalingInstancesResponseFetcher();
    }

    public Iterator<DescribeAutoScalingInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<AutoScalingInstanceDetails> autoScalingInstances() {
        Function<DescribeAutoScalingInstancesResponse, Iterator> getIterator = response -> response != null ? response.autoScalingInstances().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeAutoScalingInstancesResponseFetcher
    implements NextPageFetcher<DescribeAutoScalingInstancesResponse> {
        private DescribeAutoScalingInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutoScalingInstancesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeAutoScalingInstancesResponse nextPage(DescribeAutoScalingInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutoScalingInstancesPaginator.this.client.describeAutoScalingInstances(DescribeAutoScalingInstancesPaginator.this.firstRequest);
            }
            return DescribeAutoScalingInstancesPaginator.this.client.describeAutoScalingInstances((DescribeAutoScalingInstancesRequest)((Object)DescribeAutoScalingInstancesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

