/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustment;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustmentsCopier;
import software.amazon.awssdk.services.autoscaling.model.TargetTrackingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutScalingPolicyRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, PutScalingPolicyRequest> {
    private final String autoScalingGroupName;
    private final String policyName;
    private final String policyType;
    private final String adjustmentType;
    private final Integer minAdjustmentStep;
    private final Integer minAdjustmentMagnitude;
    private final Integer scalingAdjustment;
    private final Integer cooldown;
    private final String metricAggregationType;
    private final List<StepAdjustment> stepAdjustments;
    private final Integer estimatedInstanceWarmup;
    private final TargetTrackingConfiguration targetTrackingConfiguration;

    private PutScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.policyType = builder.policyType;
        this.adjustmentType = builder.adjustmentType;
        this.minAdjustmentStep = builder.minAdjustmentStep;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.cooldown = builder.cooldown;
        this.metricAggregationType = builder.metricAggregationType;
        this.stepAdjustments = builder.stepAdjustments;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
        this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyType() {
        return this.policyType;
    }

    public String adjustmentType() {
        return this.adjustmentType;
    }

    public Integer minAdjustmentStep() {
        return this.minAdjustmentStep;
    }

    public Integer minAdjustmentMagnitude() {
        return this.minAdjustmentMagnitude;
    }

    public Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public Integer cooldown() {
        return this.cooldown;
    }

    public String metricAggregationType() {
        return this.metricAggregationType;
    }

    public List<StepAdjustment> stepAdjustments() {
        return this.stepAdjustments;
    }

    public Integer estimatedInstanceWarmup() {
        return this.estimatedInstanceWarmup;
    }

    public TargetTrackingConfiguration targetTrackingConfiguration() {
        return this.targetTrackingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyType());
        hashCode = 31 * hashCode + Objects.hashCode(this.adjustmentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.minAdjustmentStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.minAdjustmentMagnitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(this.cooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepAdjustments());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyRequest)) {
            return false;
        }
        PutScalingPolicyRequest other = (PutScalingPolicyRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyType(), other.policyType()) && Objects.equals(this.adjustmentType(), other.adjustmentType()) && Objects.equals(this.minAdjustmentStep(), other.minAdjustmentStep()) && Objects.equals(this.minAdjustmentMagnitude(), other.minAdjustmentMagnitude()) && Objects.equals(this.scalingAdjustment(), other.scalingAdjustment()) && Objects.equals(this.cooldown(), other.cooldown()) && Objects.equals(this.metricAggregationType(), other.metricAggregationType()) && Objects.equals(this.stepAdjustments(), other.stepAdjustments()) && Objects.equals(this.estimatedInstanceWarmup(), other.estimatedInstanceWarmup()) && Objects.equals(this.targetTrackingConfiguration(), other.targetTrackingConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"PutScalingPolicyRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("PolicyName", (Object)this.policyName()).add("PolicyType", (Object)this.policyType()).add("AdjustmentType", (Object)this.adjustmentType()).add("MinAdjustmentStep", (Object)this.minAdjustmentStep()).add("MinAdjustmentMagnitude", (Object)this.minAdjustmentMagnitude()).add("ScalingAdjustment", (Object)this.scalingAdjustment()).add("Cooldown", (Object)this.cooldown()).add("MetricAggregationType", (Object)this.metricAggregationType()).add("StepAdjustments", this.stepAdjustments()).add("EstimatedInstanceWarmup", (Object)this.estimatedInstanceWarmup()).add("TargetTrackingConfiguration", (Object)this.targetTrackingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "PolicyType": {
                return Optional.of(clazz.cast(this.policyType()));
            }
            case "AdjustmentType": {
                return Optional.of(clazz.cast(this.adjustmentType()));
            }
            case "MinAdjustmentStep": {
                return Optional.of(clazz.cast(this.minAdjustmentStep()));
            }
            case "MinAdjustmentMagnitude": {
                return Optional.of(clazz.cast(this.minAdjustmentMagnitude()));
            }
            case "ScalingAdjustment": {
                return Optional.of(clazz.cast(this.scalingAdjustment()));
            }
            case "Cooldown": {
                return Optional.of(clazz.cast(this.cooldown()));
            }
            case "MetricAggregationType": {
                return Optional.of(clazz.cast(this.metricAggregationType()));
            }
            case "StepAdjustments": {
                return Optional.of(clazz.cast(this.stepAdjustments()));
            }
            case "EstimatedInstanceWarmup": {
                return Optional.of(clazz.cast(this.estimatedInstanceWarmup()));
            }
            case "TargetTrackingConfiguration": {
                return Optional.of(clazz.cast(this.targetTrackingConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String policyName;
        private String policyType;
        private String adjustmentType;
        private Integer minAdjustmentStep;
        private Integer minAdjustmentMagnitude;
        private Integer scalingAdjustment;
        private Integer cooldown;
        private String metricAggregationType;
        private List<StepAdjustment> stepAdjustments;
        private Integer estimatedInstanceWarmup;
        private TargetTrackingConfiguration targetTrackingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.policyName(model.policyName);
            this.policyType(model.policyType);
            this.adjustmentType(model.adjustmentType);
            this.minAdjustmentStep(model.minAdjustmentStep);
            this.minAdjustmentMagnitude(model.minAdjustmentMagnitude);
            this.scalingAdjustment(model.scalingAdjustment);
            this.cooldown(model.cooldown);
            this.metricAggregationType(model.metricAggregationType);
            this.stepAdjustments(model.stepAdjustments);
            this.estimatedInstanceWarmup(model.estimatedInstanceWarmup);
            this.targetTrackingConfiguration(model.targetTrackingConfiguration);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final String getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final Integer getMinAdjustmentStep() {
            return this.minAdjustmentStep;
        }

        @Override
        public final Builder minAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
            return this;
        }

        public final void setMinAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
        }

        public final Integer getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final Integer getCooldown() {
            return this.cooldown;
        }

        @Override
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        public final String getMetricAggregationType() {
            return this.metricAggregationType;
        }

        @Override
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        public final Collection<StepAdjustment.Builder> getStepAdjustments() {
            return this.stepAdjustments != null ? (Collection)this.stepAdjustments.stream().map(StepAdjustment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment ... stepAdjustments) {
            this.stepAdjustments(Arrays.asList(stepAdjustments));
            return this;
        }

        public final void setStepAdjustments(Collection<StepAdjustment.BuilderImpl> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copyFromBuilder(stepAdjustments);
        }

        public final Integer getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        public final TargetTrackingConfiguration.Builder getTargetTrackingConfiguration() {
            return this.targetTrackingConfiguration != null ? this.targetTrackingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        public final void setTargetTrackingConfiguration(TargetTrackingConfiguration.BuilderImpl targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration != null ? targetTrackingConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutScalingPolicyRequest build() {
            return new PutScalingPolicyRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, PutScalingPolicyRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder policyName(String var1);

        public Builder policyType(String var1);

        public Builder adjustmentType(String var1);

        public Builder minAdjustmentStep(Integer var1);

        public Builder minAdjustmentMagnitude(Integer var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder cooldown(Integer var1);

        public Builder metricAggregationType(String var1);

        public Builder stepAdjustments(Collection<StepAdjustment> var1);

        public Builder stepAdjustments(StepAdjustment ... var1);

        public Builder estimatedInstanceWarmup(Integer var1);

        public Builder targetTrackingConfiguration(TargetTrackingConfiguration var1);

        default public Builder targetTrackingConfiguration(Consumer<TargetTrackingConfiguration.Builder> targetTrackingConfiguration) {
            return this.targetTrackingConfiguration((TargetTrackingConfiguration)((TargetTrackingConfiguration.Builder)TargetTrackingConfiguration.builder().apply(targetTrackingConfiguration)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

