/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfigurationNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLaunchConfigurationsRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeLaunchConfigurationsRequest> {
    private final List<String> launchConfigurationNames;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribeLaunchConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.launchConfigurationNames = builder.launchConfigurationNames;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public List<String> launchConfigurationNames() {
        return this.launchConfigurationNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchConfigurationsRequest)) {
            return false;
        }
        DescribeLaunchConfigurationsRequest other = (DescribeLaunchConfigurationsRequest)((Object)obj);
        return Objects.equals(this.launchConfigurationNames(), other.launchConfigurationNames()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLaunchConfigurationsRequest").add("LaunchConfigurationNames", this.launchConfigurationNames()).add("NextToken", (Object)this.nextToken()).add("MaxRecords", (Object)this.maxRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchConfigurationNames": {
                return Optional.of(clazz.cast(this.launchConfigurationNames()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private List<String> launchConfigurationNames;
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchConfigurationsRequest model) {
            this.launchConfigurationNames(model.launchConfigurationNames);
            this.nextToken(model.nextToken);
            this.maxRecords(model.maxRecords);
        }

        public final Collection<String> getLaunchConfigurationNames() {
            return this.launchConfigurationNames;
        }

        @Override
        public final Builder launchConfigurationNames(Collection<String> launchConfigurationNames) {
            this.launchConfigurationNames = LaunchConfigurationNamesCopier.copy(launchConfigurationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurationNames(String ... launchConfigurationNames) {
            this.launchConfigurationNames(Arrays.asList(launchConfigurationNames));
            return this;
        }

        public final void setLaunchConfigurationNames(Collection<String> launchConfigurationNames) {
            this.launchConfigurationNames = LaunchConfigurationNamesCopier.copy(launchConfigurationNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeLaunchConfigurationsRequest build() {
            return new DescribeLaunchConfigurationsRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, DescribeLaunchConfigurationsRequest> {
        public Builder launchConfigurationNames(Collection<String> var1);

        public Builder launchConfigurationNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

