/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.TagDescription;

public final class DescribeTagsPaginator
implements SdkIterable<DescribeTagsResponse> {
    private final AutoScalingClient client;
    private final DescribeTagsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeTagsPaginator(AutoScalingClient client, DescribeTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTagsResponseFetcher();
    }

    public Iterator<DescribeTagsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<TagDescription> tags() {
        Function<DescribeTagsResponse, Iterator> getIterator = response -> response != null ? response.tags().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeTagsResponseFetcher
    implements NextPageFetcher<DescribeTagsResponse> {
        private DescribeTagsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTagsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeTagsResponse nextPage(DescribeTagsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTagsPaginator.this.client.describeTags(DescribeTagsPaginator.this.firstRequest);
            }
            return DescribeTagsPaginator.this.client.describeTags((DescribeTagsRequest)((Object)DescribeTagsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

