/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupAction;

public final class DescribeScheduledActionsPaginator
implements SdkIterable<DescribeScheduledActionsResponse> {
    private final AutoScalingClient client;
    private final DescribeScheduledActionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeScheduledActionsPaginator(AutoScalingClient client, DescribeScheduledActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeScheduledActionsResponseFetcher();
    }

    public Iterator<DescribeScheduledActionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ScheduledUpdateGroupAction> scheduledUpdateGroupActions() {
        Function<DescribeScheduledActionsResponse, Iterator> getIterator = response -> response != null ? response.scheduledUpdateGroupActions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeScheduledActionsResponseFetcher
    implements NextPageFetcher<DescribeScheduledActionsResponse> {
        private DescribeScheduledActionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduledActionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeScheduledActionsResponse nextPage(DescribeScheduledActionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduledActionsPaginator.this.client.describeScheduledActions(DescribeScheduledActionsPaginator.this.firstRequest);
            }
            return DescribeScheduledActionsPaginator.this.client.describeScheduledActions((DescribeScheduledActionsRequest)((Object)DescribeScheduledActionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

