/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NotificationConfiguration
implements ToCopyableBuilder<Builder, NotificationConfiguration> {
    private final String autoScalingGroupName;
    private final String topicARN;
    private final String notificationType;

    private NotificationConfiguration(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
        this.notificationType = builder.notificationType;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String topicARN() {
        return this.topicARN;
    }

    public String notificationType() {
        return this.notificationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration)obj;
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.topicARN(), other.topicARN()) && Objects.equals(this.notificationType(), other.notificationType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.topicARN() != null) {
            sb.append("TopicARN: ").append(this.topicARN()).append(",");
        }
        if (this.notificationType() != null) {
            sb.append("NotificationType: ").append(this.notificationType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "TopicARN": {
                return Optional.of(clazz.cast(this.topicARN()));
            }
            case "NotificationType": {
                return Optional.of(clazz.cast(this.notificationType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String topicARN;
        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.topicARN(model.topicARN);
            this.notificationType(model.notificationType);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getTopicARN() {
            return this.topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NotificationConfiguration> {
        public Builder autoScalingGroupName(String var1);

        public Builder topicARN(String var1);

        public Builder notificationType(String var1);
    }
}

