/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest;

public class ResumeProcessesRequestMarshaller
implements Marshaller<Request<ResumeProcessesRequest>, ResumeProcessesRequest> {
    public Request<ResumeProcessesRequest> marshall(ResumeProcessesRequest resumeProcessesRequest) {
        List<String> scalingProcessesList;
        if (resumeProcessesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resumeProcessesRequest, "AutoScalingClient");
        request.addParameter("Action", "ResumeProcesses");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (resumeProcessesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)resumeProcessesRequest.autoScalingGroupName()));
        }
        if ((scalingProcessesList = resumeProcessesRequest.scalingProcesses()) != null) {
            if (!scalingProcessesList.isEmpty()) {
                int scalingProcessesListIndex = 1;
                for (String scalingProcessesListValue : scalingProcessesList) {
                    if (scalingProcessesListValue != null) {
                        request.addParameter("ScalingProcesses.member." + scalingProcessesListIndex, StringUtils.fromString((String)scalingProcessesListValue));
                    }
                    ++scalingProcessesListIndex;
                }
            } else {
                request.addParameter("ScalingProcesses", "");
            }
        }
        return request;
    }
}

