/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.CustomizedMetricSpecification;
import software.amazon.awssdk.services.autoscaling.model.MetricDimension;
import software.amazon.awssdk.services.autoscaling.model.PredefinedMetricSpecification;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustment;
import software.amazon.awssdk.services.autoscaling.model.TargetTrackingConfiguration;

public class PutScalingPolicyRequestMarshaller
implements Marshaller<Request<PutScalingPolicyRequest>, PutScalingPolicyRequest> {
    public Request<PutScalingPolicyRequest> marshall(PutScalingPolicyRequest putScalingPolicyRequest) {
        TargetTrackingConfiguration targetTrackingConfiguration;
        List<StepAdjustment> stepAdjustmentsList;
        if (putScalingPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putScalingPolicyRequest, "AutoScalingClient");
        request.addParameter("Action", "PutScalingPolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putScalingPolicyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)putScalingPolicyRequest.autoScalingGroupName()));
        }
        if (putScalingPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)putScalingPolicyRequest.policyName()));
        }
        if (putScalingPolicyRequest.policyType() != null) {
            request.addParameter("PolicyType", StringUtils.fromString((String)putScalingPolicyRequest.policyType()));
        }
        if (putScalingPolicyRequest.adjustmentType() != null) {
            request.addParameter("AdjustmentType", StringUtils.fromString((String)putScalingPolicyRequest.adjustmentType()));
        }
        if (putScalingPolicyRequest.minAdjustmentStep() != null) {
            request.addParameter("MinAdjustmentStep", StringUtils.fromInteger((Integer)putScalingPolicyRequest.minAdjustmentStep()));
        }
        if (putScalingPolicyRequest.minAdjustmentMagnitude() != null) {
            request.addParameter("MinAdjustmentMagnitude", StringUtils.fromInteger((Integer)putScalingPolicyRequest.minAdjustmentMagnitude()));
        }
        if (putScalingPolicyRequest.scalingAdjustment() != null) {
            request.addParameter("ScalingAdjustment", StringUtils.fromInteger((Integer)putScalingPolicyRequest.scalingAdjustment()));
        }
        if (putScalingPolicyRequest.cooldown() != null) {
            request.addParameter("Cooldown", StringUtils.fromInteger((Integer)putScalingPolicyRequest.cooldown()));
        }
        if (putScalingPolicyRequest.metricAggregationType() != null) {
            request.addParameter("MetricAggregationType", StringUtils.fromString((String)putScalingPolicyRequest.metricAggregationType()));
        }
        if ((stepAdjustmentsList = putScalingPolicyRequest.stepAdjustments()) != null) {
            if (!stepAdjustmentsList.isEmpty()) {
                int stepAdjustmentsListIndex = 1;
                for (StepAdjustment stepAdjustmentsListValue : stepAdjustmentsList) {
                    if (stepAdjustmentsListValue.metricIntervalLowerBound() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalLowerBound", StringUtils.fromDouble((Double)stepAdjustmentsListValue.metricIntervalLowerBound()));
                    }
                    if (stepAdjustmentsListValue.metricIntervalUpperBound() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalUpperBound", StringUtils.fromDouble((Double)stepAdjustmentsListValue.metricIntervalUpperBound()));
                    }
                    if (stepAdjustmentsListValue.scalingAdjustment() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".ScalingAdjustment", StringUtils.fromInteger((Integer)stepAdjustmentsListValue.scalingAdjustment()));
                    }
                    ++stepAdjustmentsListIndex;
                }
            } else {
                request.addParameter("StepAdjustments", "");
            }
        }
        if (putScalingPolicyRequest.estimatedInstanceWarmup() != null) {
            request.addParameter("EstimatedInstanceWarmup", StringUtils.fromInteger((Integer)putScalingPolicyRequest.estimatedInstanceWarmup()));
        }
        if ((targetTrackingConfiguration = putScalingPolicyRequest.targetTrackingConfiguration()) != null) {
            CustomizedMetricSpecification customizedMetricSpecification;
            PredefinedMetricSpecification predefinedMetricSpecification = targetTrackingConfiguration.predefinedMetricSpecification();
            if (predefinedMetricSpecification != null) {
                if (predefinedMetricSpecification.predefinedMetricTypeString() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.PredefinedMetricType", StringUtils.fromString((String)predefinedMetricSpecification.predefinedMetricTypeString()));
                }
                if (predefinedMetricSpecification.resourceLabel() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.ResourceLabel", StringUtils.fromString((String)predefinedMetricSpecification.resourceLabel()));
                }
            }
            if ((customizedMetricSpecification = targetTrackingConfiguration.customizedMetricSpecification()) != null) {
                List<MetricDimension> dimensionsList;
                if (customizedMetricSpecification.metricName() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.MetricName", StringUtils.fromString((String)customizedMetricSpecification.metricName()));
                }
                if (customizedMetricSpecification.namespace() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Namespace", StringUtils.fromString((String)customizedMetricSpecification.namespace()));
                }
                if ((dimensionsList = customizedMetricSpecification.dimensions()) != null) {
                    if (!dimensionsList.isEmpty()) {
                        int dimensionsListIndex = 1;
                        for (MetricDimension dimensionsListValue : dimensionsList) {
                            if (dimensionsListValue.name() != null) {
                                request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.name()));
                            }
                            if (dimensionsListValue.value() != null) {
                                request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.value()));
                            }
                            ++dimensionsListIndex;
                        }
                    } else {
                        request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions", "");
                    }
                }
                if (customizedMetricSpecification.statisticString() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Statistic", StringUtils.fromString((String)customizedMetricSpecification.statisticString()));
                }
                if (customizedMetricSpecification.unit() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Unit", StringUtils.fromString((String)customizedMetricSpecification.unit()));
                }
            }
            if (targetTrackingConfiguration.targetValue() != null) {
                request.addParameter("TargetTrackingConfiguration.TargetValue", StringUtils.fromDouble((Double)targetTrackingConfiguration.targetValue()));
            }
            if (targetTrackingConfiguration.disableScaleIn() != null) {
                request.addParameter("TargetTrackingConfiguration.DisableScaleIn", StringUtils.fromBoolean((Boolean)targetTrackingConfiguration.disableScaleIn()));
            }
        }
        return request;
    }
}

