/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest;

public class PutLifecycleHookRequestMarshaller
implements Marshaller<Request<PutLifecycleHookRequest>, PutLifecycleHookRequest> {
    public Request<PutLifecycleHookRequest> marshall(PutLifecycleHookRequest putLifecycleHookRequest) {
        if (putLifecycleHookRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putLifecycleHookRequest, "AutoScalingClient");
        request.addParameter("Action", "PutLifecycleHook");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putLifecycleHookRequest.lifecycleHookName() != null) {
            request.addParameter("LifecycleHookName", StringUtils.fromString((String)putLifecycleHookRequest.lifecycleHookName()));
        }
        if (putLifecycleHookRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)putLifecycleHookRequest.autoScalingGroupName()));
        }
        if (putLifecycleHookRequest.lifecycleTransition() != null) {
            request.addParameter("LifecycleTransition", StringUtils.fromString((String)putLifecycleHookRequest.lifecycleTransition()));
        }
        if (putLifecycleHookRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)putLifecycleHookRequest.roleARN()));
        }
        if (putLifecycleHookRequest.notificationTargetARN() != null) {
            request.addParameter("NotificationTargetARN", StringUtils.fromString((String)putLifecycleHookRequest.notificationTargetARN()));
        }
        if (putLifecycleHookRequest.notificationMetadata() != null) {
            request.addParameter("NotificationMetadata", StringUtils.fromString((String)putLifecycleHookRequest.notificationMetadata()));
        }
        if (putLifecycleHookRequest.heartbeatTimeout() != null) {
            request.addParameter("HeartbeatTimeout", StringUtils.fromInteger((Integer)putLifecycleHookRequest.heartbeatTimeout()));
        }
        if (putLifecycleHookRequest.defaultResult() != null) {
            request.addParameter("DefaultResult", StringUtils.fromString((String)putLifecycleHookRequest.defaultResult()));
        }
        return request;
    }
}

