/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;

public class EnableMetricsCollectionRequestMarshaller
implements Marshaller<Request<EnableMetricsCollectionRequest>, EnableMetricsCollectionRequest> {
    public Request<EnableMetricsCollectionRequest> marshall(EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        List<String> metricsList;
        if (enableMetricsCollectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableMetricsCollectionRequest, "AutoScalingClient");
        request.addParameter("Action", "EnableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableMetricsCollectionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)enableMetricsCollectionRequest.autoScalingGroupName()));
        }
        if ((metricsList = enableMetricsCollectionRequest.metrics()) != null) {
            if (!metricsList.isEmpty()) {
                int metricsListIndex = 1;
                for (String metricsListValue : metricsList) {
                    if (metricsListValue != null) {
                        request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString((String)metricsListValue));
                    }
                    ++metricsListIndex;
                }
            } else {
                request.addParameter("Metrics", "");
            }
        }
        if (enableMetricsCollectionRequest.granularity() != null) {
            request.addParameter("Granularity", StringUtils.fromString((String)enableMetricsCollectionRequest.granularity()));
        }
        return request;
    }
}

