/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.Filter;

public class DescribeTagsRequestMarshaller
implements Marshaller<Request<DescribeTagsRequest>, DescribeTagsRequest> {
    public Request<DescribeTagsRequest> marshall(DescribeTagsRequest describeTagsRequest) {
        if (describeTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTagsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeTags");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> filtersList = describeTagsRequest.filters();
        if (filtersList != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.member." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.member." + filtersListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.member." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeTagsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeTagsRequest.nextToken()));
        }
        if (describeTagsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeTagsRequest.maxRecords()));
        }
        return request;
    }
}

