/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHookSpecification;
import software.amazon.awssdk.services.autoscaling.model.Tag;

public class CreateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<CreateAutoScalingGroupRequest>, CreateAutoScalingGroupRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateAutoScalingGroupRequest> marshall(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {
        List<Tag> list;
        List<LifecycleHookSpecification> list2;
        List<String> list3;
        List<String> targetGroupARNsList;
        List<String> loadBalancerNamesList;
        List<String> availabilityZonesList;
        if (createAutoScalingGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAutoScalingGroupRequest, "AutoScalingClient");
        request.addParameter("Action", "CreateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createAutoScalingGroupRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)createAutoScalingGroupRequest.autoScalingGroupName()));
        }
        if (createAutoScalingGroupRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString((String)createAutoScalingGroupRequest.launchConfigurationName()));
        }
        if (createAutoScalingGroupRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createAutoScalingGroupRequest.instanceId()));
        }
        if (createAutoScalingGroupRequest.minSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.minSize()));
        }
        if (createAutoScalingGroupRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.maxSize()));
        }
        if (createAutoScalingGroupRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.desiredCapacity()));
        }
        if (createAutoScalingGroupRequest.defaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.defaultCooldown()));
        }
        if ((availabilityZonesList = createAutoScalingGroupRequest.availabilityZones()) != null) {
            if (!availabilityZonesList.isEmpty()) {
                int availabilityZonesListIndex = 1;
                for (String string : availabilityZonesList) {
                    if (string != null) {
                        request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringUtils.fromString((String)string));
                    }
                    ++availabilityZonesListIndex;
                }
            } else {
                request.addParameter("AvailabilityZones", "");
            }
        }
        if ((loadBalancerNamesList = createAutoScalingGroupRequest.loadBalancerNames()) != null) {
            if (!loadBalancerNamesList.isEmpty()) {
                int loadBalancerNamesListIndex = 1;
                for (String string : loadBalancerNamesList) {
                    if (string != null) {
                        request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringUtils.fromString((String)string));
                    }
                    ++loadBalancerNamesListIndex;
                }
            } else {
                request.addParameter("LoadBalancerNames", "");
            }
        }
        if ((targetGroupARNsList = createAutoScalingGroupRequest.targetGroupARNs()) != null) {
            if (!targetGroupARNsList.isEmpty()) {
                boolean bl = true;
                for (String string : targetGroupARNsList) {
                    void var6_12;
                    if (string != null) {
                        request.addParameter("TargetGroupARNs.member." + (int)var6_12, StringUtils.fromString((String)string));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("TargetGroupARNs", "");
            }
        }
        if (createAutoScalingGroupRequest.healthCheckType() != null) {
            request.addParameter("HealthCheckType", StringUtils.fromString((String)createAutoScalingGroupRequest.healthCheckType()));
        }
        if (createAutoScalingGroupRequest.healthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.healthCheckGracePeriod()));
        }
        if (createAutoScalingGroupRequest.placementGroup() != null) {
            request.addParameter("PlacementGroup", StringUtils.fromString((String)createAutoScalingGroupRequest.placementGroup()));
        }
        if (createAutoScalingGroupRequest.vpcZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier", StringUtils.fromString((String)createAutoScalingGroupRequest.vpcZoneIdentifier()));
        }
        if ((list3 = createAutoScalingGroupRequest.terminationPolicies()) != null) {
            if (!list3.isEmpty()) {
                boolean bl = true;
                for (String string : list3) {
                    void var7_18;
                    if (string != null) {
                        request.addParameter("TerminationPolicies.member." + (int)var7_18, StringUtils.fromString((String)string));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("TerminationPolicies", "");
            }
        }
        if (createAutoScalingGroupRequest.newInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn", StringUtils.fromBoolean((Boolean)createAutoScalingGroupRequest.newInstancesProtectedFromScaleIn()));
        }
        if ((list2 = createAutoScalingGroupRequest.lifecycleHookSpecificationList()) != null) {
            if (!list2.isEmpty()) {
                boolean bl = true;
                for (LifecycleHookSpecification lifecycleHookSpecificationListListValue : list2) {
                    void var8_24;
                    if (lifecycleHookSpecificationListListValue.lifecycleHookName() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + (int)var8_24 + ".LifecycleHookName", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.lifecycleHookName()));
                    }
                    if (lifecycleHookSpecificationListListValue.lifecycleTransition() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + (int)var8_24 + ".LifecycleTransition", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.lifecycleTransition()));
                    }
                    if (lifecycleHookSpecificationListListValue.notificationMetadata() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + (int)var8_24 + ".NotificationMetadata", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.notificationMetadata()));
                    }
                    if (lifecycleHookSpecificationListListValue.heartbeatTimeout() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + (int)var8_24 + ".HeartbeatTimeout", StringUtils.fromInteger((Integer)lifecycleHookSpecificationListListValue.heartbeatTimeout()));
                    }
                    if (lifecycleHookSpecificationListListValue.defaultResult() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + (int)var8_24 + ".DefaultResult", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.defaultResult()));
                    }
                    if (lifecycleHookSpecificationListListValue.notificationTargetARN() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + (int)var8_24 + ".NotificationTargetARN", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.notificationTargetARN()));
                    }
                    if (lifecycleHookSpecificationListListValue.roleARN() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + (int)var8_24 + ".RoleARN", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.roleARN()));
                    }
                    ++var8_24;
                }
            } else {
                request.addParameter("LifecycleHookSpecificationList", "");
            }
        }
        if ((list = createAutoScalingGroupRequest.tags()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : list) {
                    void var9_30;
                    if (tagsListValue.resourceId() != null) {
                        request.addParameter("Tags.member." + (int)var9_30 + ".ResourceId", StringUtils.fromString((String)tagsListValue.resourceId()));
                    }
                    if (tagsListValue.resourceType() != null) {
                        request.addParameter("Tags.member." + (int)var9_30 + ".ResourceType", StringUtils.fromString((String)tagsListValue.resourceType()));
                    }
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + (int)var9_30 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var9_30 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    if (tagsListValue.propagateAtLaunch() != null) {
                        request.addParameter("Tags.member." + (int)var9_30 + ".PropagateAtLaunch", StringUtils.fromBoolean((Boolean)tagsListValue.propagateAtLaunch()));
                    }
                    ++var9_30;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

