/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;

public class CompleteLifecycleActionRequestMarshaller
implements Marshaller<Request<CompleteLifecycleActionRequest>, CompleteLifecycleActionRequest> {
    public Request<CompleteLifecycleActionRequest> marshall(CompleteLifecycleActionRequest completeLifecycleActionRequest) {
        if (completeLifecycleActionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)completeLifecycleActionRequest, "AutoScalingClient");
        request.addParameter("Action", "CompleteLifecycleAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (completeLifecycleActionRequest.lifecycleHookName() != null) {
            request.addParameter("LifecycleHookName", StringUtils.fromString((String)completeLifecycleActionRequest.lifecycleHookName()));
        }
        if (completeLifecycleActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)completeLifecycleActionRequest.autoScalingGroupName()));
        }
        if (completeLifecycleActionRequest.lifecycleActionToken() != null) {
            request.addParameter("LifecycleActionToken", StringUtils.fromString((String)completeLifecycleActionRequest.lifecycleActionToken()));
        }
        if (completeLifecycleActionRequest.lifecycleActionResult() != null) {
            request.addParameter("LifecycleActionResult", StringUtils.fromString((String)completeLifecycleActionRequest.lifecycleActionResult()));
        }
        if (completeLifecycleActionRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)completeLifecycleActionRequest.instanceId()));
        }
        return request;
    }
}

