/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest;

public class AttachLoadBalancersRequestMarshaller
implements Marshaller<Request<AttachLoadBalancersRequest>, AttachLoadBalancersRequest> {
    public Request<AttachLoadBalancersRequest> marshall(AttachLoadBalancersRequest attachLoadBalancersRequest) {
        List<String> loadBalancerNamesList;
        if (attachLoadBalancersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachLoadBalancersRequest, "AutoScalingClient");
        request.addParameter("Action", "AttachLoadBalancers");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachLoadBalancersRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)attachLoadBalancersRequest.autoScalingGroupName()));
        }
        if ((loadBalancerNamesList = attachLoadBalancersRequest.loadBalancerNames()) != null) {
            if (!loadBalancerNamesList.isEmpty()) {
                int loadBalancerNamesListIndex = 1;
                for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                    if (loadBalancerNamesListValue != null) {
                        request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringUtils.fromString((String)loadBalancerNamesListValue));
                    }
                    ++loadBalancerNamesListIndex;
                }
            } else {
                request.addParameter("LoadBalancerNames", "");
            }
        }
        return request;
    }
}

