/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.NotificationConfiguration;

public final class DescribeNotificationConfigurationsPaginator
implements SdkIterable<DescribeNotificationConfigurationsResponse> {
    private final AutoScalingClient client;
    private final DescribeNotificationConfigurationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeNotificationConfigurationsPaginator(AutoScalingClient client, DescribeNotificationConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeNotificationConfigurationsResponseFetcher();
    }

    public Iterator<DescribeNotificationConfigurationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<NotificationConfiguration> notificationConfigurations() {
        Function<DescribeNotificationConfigurationsResponse, Iterator> getIterator = response -> response != null ? response.notificationConfigurations().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeNotificationConfigurationsResponseFetcher
    implements NextPageFetcher<DescribeNotificationConfigurationsResponse> {
        private DescribeNotificationConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNotificationConfigurationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeNotificationConfigurationsResponse nextPage(DescribeNotificationConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNotificationConfigurationsPaginator.this.client.describeNotificationConfigurations(DescribeNotificationConfigurationsPaginator.this.firstRequest);
            }
            return DescribeNotificationConfigurationsPaginator.this.client.describeNotificationConfigurations((DescribeNotificationConfigurationsRequest)((Object)DescribeNotificationConfigurationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

