/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompleteLifecycleActionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CompleteLifecycleActionRequest> {
    private final String lifecycleHookName;
    private final String autoScalingGroupName;
    private final String lifecycleActionToken;
    private final String lifecycleActionResult;
    private final String instanceId;

    private CompleteLifecycleActionRequest(BuilderImpl builder) {
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleActionToken = builder.lifecycleActionToken;
        this.lifecycleActionResult = builder.lifecycleActionResult;
        this.instanceId = builder.instanceId;
    }

    public String lifecycleHookName() {
        return this.lifecycleHookName;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String lifecycleActionToken() {
        return this.lifecycleActionToken;
    }

    public String lifecycleActionResult() {
        return this.lifecycleActionResult;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleActionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleActionResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteLifecycleActionRequest)) {
            return false;
        }
        CompleteLifecycleActionRequest other = (CompleteLifecycleActionRequest)((Object)obj);
        return Objects.equals(this.lifecycleHookName(), other.lifecycleHookName()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.lifecycleActionToken(), other.lifecycleActionToken()) && Objects.equals(this.lifecycleActionResult(), other.lifecycleActionResult()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lifecycleHookName() != null) {
            sb.append("LifecycleHookName: ").append(this.lifecycleHookName()).append(",");
        }
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.lifecycleActionToken() != null) {
            sb.append("LifecycleActionToken: ").append(this.lifecycleActionToken()).append(",");
        }
        if (this.lifecycleActionResult() != null) {
            sb.append("LifecycleActionResult: ").append(this.lifecycleActionResult()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHookName": {
                return Optional.of(clazz.cast(this.lifecycleHookName()));
            }
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "LifecycleActionToken": {
                return Optional.of(clazz.cast(this.lifecycleActionToken()));
            }
            case "LifecycleActionResult": {
                return Optional.of(clazz.cast(this.lifecycleActionResult()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycleHookName;
        private String autoScalingGroupName;
        private String lifecycleActionToken;
        private String lifecycleActionResult;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteLifecycleActionRequest model) {
            this.lifecycleHookName(model.lifecycleHookName);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.lifecycleActionToken(model.lifecycleActionToken);
            this.lifecycleActionResult(model.lifecycleActionResult);
            this.instanceId(model.instanceId);
        }

        public final String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLifecycleActionToken() {
            return this.lifecycleActionToken;
        }

        @Override
        public final Builder lifecycleActionToken(String lifecycleActionToken) {
            this.lifecycleActionToken = lifecycleActionToken;
            return this;
        }

        public final void setLifecycleActionToken(String lifecycleActionToken) {
            this.lifecycleActionToken = lifecycleActionToken;
        }

        public final String getLifecycleActionResult() {
            return this.lifecycleActionResult;
        }

        @Override
        public final Builder lifecycleActionResult(String lifecycleActionResult) {
            this.lifecycleActionResult = lifecycleActionResult;
            return this;
        }

        public final void setLifecycleActionResult(String lifecycleActionResult) {
            this.lifecycleActionResult = lifecycleActionResult;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public CompleteLifecycleActionRequest build() {
            return new CompleteLifecycleActionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompleteLifecycleActionRequest> {
        public Builder lifecycleHookName(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder lifecycleActionToken(String var1);

        public Builder lifecycleActionResult(String var1);

        public Builder instanceId(String var1);
    }
}

