/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;

public class DetachLoadBalancerTargetGroupsRequestMarshaller
implements Marshaller<Request<DetachLoadBalancerTargetGroupsRequest>, DetachLoadBalancerTargetGroupsRequest> {
    public Request<DetachLoadBalancerTargetGroupsRequest> marshall(DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) {
        List<String> targetGroupARNsList;
        if (detachLoadBalancerTargetGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachLoadBalancerTargetGroupsRequest, "AutoScalingClient");
        request.addParameter("Action", "DetachLoadBalancerTargetGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachLoadBalancerTargetGroupsRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)detachLoadBalancerTargetGroupsRequest.autoScalingGroupName()));
        }
        if ((targetGroupARNsList = detachLoadBalancerTargetGroupsRequest.targetGroupARNs()) != null) {
            if (!targetGroupARNsList.isEmpty()) {
                int targetGroupARNsListIndex = 1;
                for (String targetGroupARNsListValue : targetGroupARNsList) {
                    if (targetGroupARNsListValue != null) {
                        request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex, StringUtils.fromString((String)targetGroupARNsListValue));
                    }
                    ++targetGroupARNsListIndex;
                }
            } else {
                request.addParameter("TargetGroupARNs", "");
            }
        }
        return request;
    }
}

