/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;

public class DescribePoliciesRequestMarshaller
implements Marshaller<Request<DescribePoliciesRequest>, DescribePoliciesRequest> {
    public Request<DescribePoliciesRequest> marshall(DescribePoliciesRequest describePoliciesRequest) {
        List<String> policyTypesList;
        List<String> policyNamesList;
        if (describePoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describePoliciesRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribePolicies");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describePoliciesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)describePoliciesRequest.autoScalingGroupName()));
        }
        if ((policyNamesList = describePoliciesRequest.policyNames()) != null) {
            if (!policyNamesList.isEmpty()) {
                int policyNamesListIndex = 1;
                for (String policyNamesListValue : policyNamesList) {
                    if (policyNamesListValue != null) {
                        request.addParameter("PolicyNames.member." + policyNamesListIndex, StringUtils.fromString((String)policyNamesListValue));
                    }
                    ++policyNamesListIndex;
                }
            } else {
                request.addParameter("PolicyNames", "");
            }
        }
        if ((policyTypesList = describePoliciesRequest.policyTypes()) != null) {
            if (!policyTypesList.isEmpty()) {
                int policyTypesListIndex = 1;
                for (String policyTypesListValue : policyTypesList) {
                    if (policyTypesListValue != null) {
                        request.addParameter("PolicyTypes.member." + policyTypesListIndex, StringUtils.fromString((String)policyTypesListValue));
                    }
                    ++policyTypesListIndex;
                }
            } else {
                request.addParameter("PolicyTypes", "");
            }
        }
        if (describePoliciesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describePoliciesRequest.nextToken()));
        }
        if (describePoliciesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describePoliciesRequest.maxRecords()));
        }
        return request;
    }
}

