/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Tag
implements ToCopyableBuilder<Builder, Tag> {
    private final String resourceId;
    private final String resourceType;
    private final String key;
    private final String value;
    private final Boolean propagateAtLaunch;

    private Tag(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.key = builder.key;
        this.value = builder.value;
        this.propagateAtLaunch = builder.propagateAtLaunch;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Boolean propagateAtLaunch() {
        return this.propagateAtLaunch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.propagateAtLaunch() == null ? 0 : this.propagateAtLaunch().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)obj;
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.propagateAtLaunch() == null ^ this.propagateAtLaunch() == null) {
            return false;
        }
        return other.propagateAtLaunch() == null || other.propagateAtLaunch().equals(this.propagateAtLaunch());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.propagateAtLaunch() != null) {
            sb.append("PropagateAtLaunch: ").append(this.propagateAtLaunch()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "PropagateAtLaunch": {
                return Optional.of(clazz.cast(this.propagateAtLaunch()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;
        private String key;
        private String value;
        private Boolean propagateAtLaunch;

        private BuilderImpl() {
        }

        private BuilderImpl(Tag model) {
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.key(model.key);
            this.value(model.value);
            this.propagateAtLaunch(model.propagateAtLaunch);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Boolean getPropagateAtLaunch() {
            return this.propagateAtLaunch;
        }

        @Override
        public final Builder propagateAtLaunch(Boolean propagateAtLaunch) {
            this.propagateAtLaunch = propagateAtLaunch;
            return this;
        }

        public final void setPropagateAtLaunch(Boolean propagateAtLaunch) {
            this.propagateAtLaunch = propagateAtLaunch;
        }

        public Tag build() {
            return new Tag(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Tag> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder key(String var1);

        public Builder value(String var1);

        public Builder propagateAtLaunch(Boolean var1);
    }
}

