/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.autoscaling.model.Alarm;
import software.amazon.awssdk.services.autoscaling.model.AlarmsCopier;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustment;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustmentsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScalingPolicy
implements ToCopyableBuilder<Builder, ScalingPolicy> {
    private final String autoScalingGroupName;
    private final String policyName;
    private final String policyARN;
    private final String policyType;
    private final String adjustmentType;
    private final Integer minAdjustmentStep;
    private final Integer minAdjustmentMagnitude;
    private final Integer scalingAdjustment;
    private final Integer cooldown;
    private final List<StepAdjustment> stepAdjustments;
    private final String metricAggregationType;
    private final Integer estimatedInstanceWarmup;
    private final List<Alarm> alarms;

    private ScalingPolicy(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.policyARN = builder.policyARN;
        this.policyType = builder.policyType;
        this.adjustmentType = builder.adjustmentType;
        this.minAdjustmentStep = builder.minAdjustmentStep;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.cooldown = builder.cooldown;
        this.stepAdjustments = builder.stepAdjustments;
        this.metricAggregationType = builder.metricAggregationType;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
        this.alarms = builder.alarms;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyARN() {
        return this.policyARN;
    }

    public String policyType() {
        return this.policyType;
    }

    public String adjustmentType() {
        return this.adjustmentType;
    }

    public Integer minAdjustmentStep() {
        return this.minAdjustmentStep;
    }

    public Integer minAdjustmentMagnitude() {
        return this.minAdjustmentMagnitude;
    }

    public Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public Integer cooldown() {
        return this.cooldown;
    }

    public List<StepAdjustment> stepAdjustments() {
        return this.stepAdjustments;
    }

    public String metricAggregationType() {
        return this.metricAggregationType;
    }

    public Integer estimatedInstanceWarmup() {
        return this.estimatedInstanceWarmup;
    }

    public List<Alarm> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        hashCode = 31 * hashCode + (this.policyARN() == null ? 0 : this.policyARN().hashCode());
        hashCode = 31 * hashCode + (this.policyType() == null ? 0 : this.policyType().hashCode());
        hashCode = 31 * hashCode + (this.adjustmentType() == null ? 0 : this.adjustmentType().hashCode());
        hashCode = 31 * hashCode + (this.minAdjustmentStep() == null ? 0 : this.minAdjustmentStep().hashCode());
        hashCode = 31 * hashCode + (this.minAdjustmentMagnitude() == null ? 0 : this.minAdjustmentMagnitude().hashCode());
        hashCode = 31 * hashCode + (this.scalingAdjustment() == null ? 0 : this.scalingAdjustment().hashCode());
        hashCode = 31 * hashCode + (this.cooldown() == null ? 0 : this.cooldown().hashCode());
        hashCode = 31 * hashCode + (this.stepAdjustments() == null ? 0 : this.stepAdjustments().hashCode());
        hashCode = 31 * hashCode + (this.metricAggregationType() == null ? 0 : this.metricAggregationType().hashCode());
        hashCode = 31 * hashCode + (this.estimatedInstanceWarmup() == null ? 0 : this.estimatedInstanceWarmup().hashCode());
        hashCode = 31 * hashCode + (this.alarms() == null ? 0 : this.alarms().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyARN() == null ^ this.policyARN() == null) {
            return false;
        }
        if (other.policyARN() != null && !other.policyARN().equals(this.policyARN())) {
            return false;
        }
        if (other.policyType() == null ^ this.policyType() == null) {
            return false;
        }
        if (other.policyType() != null && !other.policyType().equals(this.policyType())) {
            return false;
        }
        if (other.adjustmentType() == null ^ this.adjustmentType() == null) {
            return false;
        }
        if (other.adjustmentType() != null && !other.adjustmentType().equals(this.adjustmentType())) {
            return false;
        }
        if (other.minAdjustmentStep() == null ^ this.minAdjustmentStep() == null) {
            return false;
        }
        if (other.minAdjustmentStep() != null && !other.minAdjustmentStep().equals(this.minAdjustmentStep())) {
            return false;
        }
        if (other.minAdjustmentMagnitude() == null ^ this.minAdjustmentMagnitude() == null) {
            return false;
        }
        if (other.minAdjustmentMagnitude() != null && !other.minAdjustmentMagnitude().equals(this.minAdjustmentMagnitude())) {
            return false;
        }
        if (other.scalingAdjustment() == null ^ this.scalingAdjustment() == null) {
            return false;
        }
        if (other.scalingAdjustment() != null && !other.scalingAdjustment().equals(this.scalingAdjustment())) {
            return false;
        }
        if (other.cooldown() == null ^ this.cooldown() == null) {
            return false;
        }
        if (other.cooldown() != null && !other.cooldown().equals(this.cooldown())) {
            return false;
        }
        if (other.stepAdjustments() == null ^ this.stepAdjustments() == null) {
            return false;
        }
        if (other.stepAdjustments() != null && !other.stepAdjustments().equals(this.stepAdjustments())) {
            return false;
        }
        if (other.metricAggregationType() == null ^ this.metricAggregationType() == null) {
            return false;
        }
        if (other.metricAggregationType() != null && !other.metricAggregationType().equals(this.metricAggregationType())) {
            return false;
        }
        if (other.estimatedInstanceWarmup() == null ^ this.estimatedInstanceWarmup() == null) {
            return false;
        }
        if (other.estimatedInstanceWarmup() != null && !other.estimatedInstanceWarmup().equals(this.estimatedInstanceWarmup())) {
            return false;
        }
        if (other.alarms() == null ^ this.alarms() == null) {
            return false;
        }
        return other.alarms() == null || other.alarms().equals(this.alarms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.policyARN() != null) {
            sb.append("PolicyARN: ").append(this.policyARN()).append(",");
        }
        if (this.policyType() != null) {
            sb.append("PolicyType: ").append(this.policyType()).append(",");
        }
        if (this.adjustmentType() != null) {
            sb.append("AdjustmentType: ").append(this.adjustmentType()).append(",");
        }
        if (this.minAdjustmentStep() != null) {
            sb.append("MinAdjustmentStep: ").append(this.minAdjustmentStep()).append(",");
        }
        if (this.minAdjustmentMagnitude() != null) {
            sb.append("MinAdjustmentMagnitude: ").append(this.minAdjustmentMagnitude()).append(",");
        }
        if (this.scalingAdjustment() != null) {
            sb.append("ScalingAdjustment: ").append(this.scalingAdjustment()).append(",");
        }
        if (this.cooldown() != null) {
            sb.append("Cooldown: ").append(this.cooldown()).append(",");
        }
        if (this.stepAdjustments() != null) {
            sb.append("StepAdjustments: ").append(this.stepAdjustments()).append(",");
        }
        if (this.metricAggregationType() != null) {
            sb.append("MetricAggregationType: ").append(this.metricAggregationType()).append(",");
        }
        if (this.estimatedInstanceWarmup() != null) {
            sb.append("EstimatedInstanceWarmup: ").append(this.estimatedInstanceWarmup()).append(",");
        }
        if (this.alarms() != null) {
            sb.append("Alarms: ").append(this.alarms()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "PolicyARN": {
                return Optional.of(clazz.cast(this.policyARN()));
            }
            case "PolicyType": {
                return Optional.of(clazz.cast(this.policyType()));
            }
            case "AdjustmentType": {
                return Optional.of(clazz.cast(this.adjustmentType()));
            }
            case "MinAdjustmentStep": {
                return Optional.of(clazz.cast(this.minAdjustmentStep()));
            }
            case "MinAdjustmentMagnitude": {
                return Optional.of(clazz.cast(this.minAdjustmentMagnitude()));
            }
            case "ScalingAdjustment": {
                return Optional.of(clazz.cast(this.scalingAdjustment()));
            }
            case "Cooldown": {
                return Optional.of(clazz.cast(this.cooldown()));
            }
            case "StepAdjustments": {
                return Optional.of(clazz.cast(this.stepAdjustments()));
            }
            case "MetricAggregationType": {
                return Optional.of(clazz.cast(this.metricAggregationType()));
            }
            case "EstimatedInstanceWarmup": {
                return Optional.of(clazz.cast(this.estimatedInstanceWarmup()));
            }
            case "Alarms": {
                return Optional.of(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String policyName;
        private String policyARN;
        private String policyType;
        private String adjustmentType;
        private Integer minAdjustmentStep;
        private Integer minAdjustmentMagnitude;
        private Integer scalingAdjustment;
        private Integer cooldown;
        private List<StepAdjustment> stepAdjustments;
        private String metricAggregationType;
        private Integer estimatedInstanceWarmup;
        private List<Alarm> alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.policyName(model.policyName);
            this.policyARN(model.policyARN);
            this.policyType(model.policyType);
            this.adjustmentType(model.adjustmentType);
            this.minAdjustmentStep(model.minAdjustmentStep);
            this.minAdjustmentMagnitude(model.minAdjustmentMagnitude);
            this.scalingAdjustment(model.scalingAdjustment);
            this.cooldown(model.cooldown);
            this.stepAdjustments(model.stepAdjustments);
            this.metricAggregationType(model.metricAggregationType);
            this.estimatedInstanceWarmup(model.estimatedInstanceWarmup);
            this.alarms(model.alarms);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyARN() {
            return this.policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final String getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final Integer getMinAdjustmentStep() {
            return this.minAdjustmentStep;
        }

        @Override
        public final Builder minAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
            return this;
        }

        public final void setMinAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
        }

        public final Integer getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final Integer getCooldown() {
            return this.cooldown;
        }

        @Override
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        public final Collection<StepAdjustment.Builder> getStepAdjustments() {
            return this.stepAdjustments != null ? (Collection)this.stepAdjustments.stream().map(StepAdjustment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment ... stepAdjustments) {
            this.stepAdjustments(Arrays.asList(stepAdjustments));
            return this;
        }

        public final void setStepAdjustments(Collection<StepAdjustment.BuilderImpl> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copyFromBuilder(stepAdjustments);
        }

        public final String getMetricAggregationType() {
            return this.metricAggregationType;
        }

        @Override
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        public final Integer getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        public final Collection<Alarm.Builder> getAlarms() {
            return this.alarms != null ? (Collection)this.alarms.stream().map(Alarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmsCopier.copyFromBuilder(alarms);
        }

        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingPolicy> {
        public Builder autoScalingGroupName(String var1);

        public Builder policyName(String var1);

        public Builder policyARN(String var1);

        public Builder policyType(String var1);

        public Builder adjustmentType(String var1);

        public Builder minAdjustmentStep(Integer var1);

        public Builder minAdjustmentMagnitude(Integer var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder cooldown(Integer var1);

        public Builder stepAdjustments(Collection<StepAdjustment> var1);

        public Builder stepAdjustments(StepAdjustment ... var1);

        public Builder metricAggregationType(String var1);

        public Builder estimatedInstanceWarmup(Integer var1);

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);
    }
}

