/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import software.amazon.awssdk.services.autoscaling.model.LifecycleState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Instance
implements ToCopyableBuilder<Builder, Instance> {
    private final String instanceId;
    private final String availabilityZone;
    private final String lifecycleState;
    private final String healthStatus;
    private final String launchConfigurationName;
    private final Boolean protectedFromScaleIn;

    private Instance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.availabilityZone = builder.availabilityZone;
        this.lifecycleState = builder.lifecycleState;
        this.healthStatus = builder.healthStatus;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.protectedFromScaleIn = builder.protectedFromScaleIn;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public LifecycleState lifecycleState() {
        return LifecycleState.fromValue(this.lifecycleState);
    }

    public String lifecycleStateString() {
        return this.lifecycleState;
    }

    public String healthStatus() {
        return this.healthStatus;
    }

    public String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public Boolean protectedFromScaleIn() {
        return this.protectedFromScaleIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.lifecycleStateString() == null ? 0 : this.lifecycleStateString().hashCode());
        hashCode = 31 * hashCode + (this.healthStatus() == null ? 0 : this.healthStatus().hashCode());
        hashCode = 31 * hashCode + (this.launchConfigurationName() == null ? 0 : this.launchConfigurationName().hashCode());
        hashCode = 31 * hashCode + (this.protectedFromScaleIn() == null ? 0 : this.protectedFromScaleIn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.lifecycleStateString() == null ^ this.lifecycleStateString() == null) {
            return false;
        }
        if (other.lifecycleStateString() != null && !other.lifecycleStateString().equals(this.lifecycleStateString())) {
            return false;
        }
        if (other.healthStatus() == null ^ this.healthStatus() == null) {
            return false;
        }
        if (other.healthStatus() != null && !other.healthStatus().equals(this.healthStatus())) {
            return false;
        }
        if (other.launchConfigurationName() == null ^ this.launchConfigurationName() == null) {
            return false;
        }
        if (other.launchConfigurationName() != null && !other.launchConfigurationName().equals(this.launchConfigurationName())) {
            return false;
        }
        if (other.protectedFromScaleIn() == null ^ this.protectedFromScaleIn() == null) {
            return false;
        }
        return other.protectedFromScaleIn() == null || other.protectedFromScaleIn().equals(this.protectedFromScaleIn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.lifecycleStateString() != null) {
            sb.append("LifecycleState: ").append(this.lifecycleStateString()).append(",");
        }
        if (this.healthStatus() != null) {
            sb.append("HealthStatus: ").append(this.healthStatus()).append(",");
        }
        if (this.launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(this.launchConfigurationName()).append(",");
        }
        if (this.protectedFromScaleIn() != null) {
            sb.append("ProtectedFromScaleIn: ").append(this.protectedFromScaleIn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "LifecycleState": {
                return Optional.of(clazz.cast(this.lifecycleStateString()));
            }
            case "HealthStatus": {
                return Optional.of(clazz.cast(this.healthStatus()));
            }
            case "LaunchConfigurationName": {
                return Optional.of(clazz.cast(this.launchConfigurationName()));
            }
            case "ProtectedFromScaleIn": {
                return Optional.of(clazz.cast(this.protectedFromScaleIn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String availabilityZone;
        private String lifecycleState;
        private String healthStatus;
        private String launchConfigurationName;
        private Boolean protectedFromScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.instanceId(model.instanceId);
            this.availabilityZone(model.availabilityZone);
            this.lifecycleState(model.lifecycleState);
            this.healthStatus(model.healthStatus);
            this.launchConfigurationName(model.launchConfigurationName);
            this.protectedFromScaleIn(model.protectedFromScaleIn);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getLifecycleState() {
            return this.lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        @Override
        public final Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState(lifecycleState.toString());
            return this;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final Boolean getProtectedFromScaleIn() {
            return this.protectedFromScaleIn;
        }

        @Override
        public final Builder protectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
            return this;
        }

        public final void setProtectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
        }

        public Instance build() {
            return new Instance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Instance> {
        public Builder instanceId(String var1);

        public Builder availabilityZone(String var1);

        public Builder lifecycleState(String var1);

        public Builder lifecycleState(LifecycleState var1);

        public Builder healthStatus(String var1);

        public Builder launchConfigurationName(String var1);

        public Builder protectedFromScaleIn(Boolean var1);
    }
}

