/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.MetricsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableMetricsCollectionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, EnableMetricsCollectionRequest> {
    private final String autoScalingGroupName;
    private final List<String> metrics;
    private final String granularity;

    private EnableMetricsCollectionRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.metrics = builder.metrics;
        this.granularity = builder.granularity;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> metrics() {
        return this.metrics;
    }

    public String granularity() {
        return this.granularity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.metrics() == null ? 0 : this.metrics().hashCode());
        hashCode = 31 * hashCode + (this.granularity() == null ? 0 : this.granularity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableMetricsCollectionRequest)) {
            return false;
        }
        EnableMetricsCollectionRequest other = (EnableMetricsCollectionRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.metrics() == null ^ this.metrics() == null) {
            return false;
        }
        if (other.metrics() != null && !other.metrics().equals(this.metrics())) {
            return false;
        }
        if (other.granularity() == null ^ this.granularity() == null) {
            return false;
        }
        return other.granularity() == null || other.granularity().equals(this.granularity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.metrics() != null) {
            sb.append("Metrics: ").append(this.metrics()).append(",");
        }
        if (this.granularity() != null) {
            sb.append("Granularity: ").append(this.granularity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "Metrics": {
                return Optional.of(clazz.cast(this.metrics()));
            }
            case "Granularity": {
                return Optional.of(clazz.cast(this.granularity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> metrics;
        private String granularity;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableMetricsCollectionRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.metrics(model.metrics);
            this.granularity(model.granularity);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getMetrics() {
            return this.metrics;
        }

        @Override
        public final Builder metrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(String ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
        }

        public final String getGranularity() {
            return this.granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        public EnableMetricsCollectionRequest build() {
            return new EnableMetricsCollectionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnableMetricsCollectionRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder metrics(Collection<String> var1);

        public Builder metrics(String ... var1);

        public Builder granularity(String var1);
    }
}

