/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteScheduledActionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteScheduledActionRequest> {
    private final String autoScalingGroupName;
    private final String scheduledActionName;

    private DeleteScheduledActionRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionName = builder.scheduledActionName;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String scheduledActionName() {
        return this.scheduledActionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.scheduledActionName() == null ? 0 : this.scheduledActionName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteScheduledActionRequest)) {
            return false;
        }
        DeleteScheduledActionRequest other = (DeleteScheduledActionRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.scheduledActionName() == null ^ this.scheduledActionName() == null) {
            return false;
        }
        return other.scheduledActionName() == null || other.scheduledActionName().equals(this.scheduledActionName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.scheduledActionName() != null) {
            sb.append("ScheduledActionName: ").append(this.scheduledActionName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "ScheduledActionName": {
                return Optional.of(clazz.cast(this.scheduledActionName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String scheduledActionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteScheduledActionRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.scheduledActionName(model.scheduledActionName);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getScheduledActionName() {
            return this.scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public DeleteScheduledActionRequest build() {
            return new DeleteScheduledActionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteScheduledActionRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder scheduledActionName(String var1);
    }
}

