/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import software.amazon.awssdk.services.autoscaling.model.Ebs;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BlockDeviceMapping
implements ToCopyableBuilder<Builder, BlockDeviceMapping> {
    private final String virtualName;
    private final String deviceName;
    private final Ebs ebs;
    private final Boolean noDevice;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.virtualName = builder.virtualName;
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
    }

    public String virtualName() {
        return this.virtualName;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public Ebs ebs() {
        return this.ebs;
    }

    public Boolean noDevice() {
        return this.noDevice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.virtualName() == null ? 0 : this.virtualName().hashCode());
        hashCode = 31 * hashCode + (this.deviceName() == null ? 0 : this.deviceName().hashCode());
        hashCode = 31 * hashCode + (this.ebs() == null ? 0 : this.ebs().hashCode());
        hashCode = 31 * hashCode + (this.noDevice() == null ? 0 : this.noDevice().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping)obj;
        if (other.virtualName() == null ^ this.virtualName() == null) {
            return false;
        }
        if (other.virtualName() != null && !other.virtualName().equals(this.virtualName())) {
            return false;
        }
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.ebs() == null ^ this.ebs() == null) {
            return false;
        }
        if (other.ebs() != null && !other.ebs().equals(this.ebs())) {
            return false;
        }
        if (other.noDevice() == null ^ this.noDevice() == null) {
            return false;
        }
        return other.noDevice() == null || other.noDevice().equals(this.noDevice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.virtualName() != null) {
            sb.append("VirtualName: ").append(this.virtualName()).append(",");
        }
        if (this.deviceName() != null) {
            sb.append("DeviceName: ").append(this.deviceName()).append(",");
        }
        if (this.ebs() != null) {
            sb.append("Ebs: ").append(this.ebs()).append(",");
        }
        if (this.noDevice() != null) {
            sb.append("NoDevice: ").append(this.noDevice()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VirtualName": {
                return Optional.of(clazz.cast(this.virtualName()));
            }
            case "DeviceName": {
                return Optional.of(clazz.cast(this.deviceName()));
            }
            case "Ebs": {
                return Optional.of(clazz.cast(this.ebs()));
            }
            case "NoDevice": {
                return Optional.of(clazz.cast(this.noDevice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String virtualName;
        private String deviceName;
        private Ebs ebs;
        private Boolean noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            this.virtualName(model.virtualName);
            this.deviceName(model.deviceName);
            this.ebs(model.ebs);
            this.noDevice(model.noDevice);
        }

        public final String getVirtualName() {
            return this.virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final Ebs.Builder getEbs() {
            return this.ebs != null ? this.ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(Ebs ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(Ebs.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public final Boolean getNoDevice() {
            return this.noDevice;
        }

        @Override
        public final Builder noDevice(Boolean noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(Boolean noDevice) {
            this.noDevice = noDevice;
        }

        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BlockDeviceMapping> {
        public Builder virtualName(String var1);

        public Builder deviceName(String var1);

        public Builder ebs(Ebs var1);

        public Builder noDevice(Boolean var1);
    }
}

