/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeScalingActivitiesRequestMarshaller
implements Marshaller<Request<DescribeScalingActivitiesRequest>, DescribeScalingActivitiesRequest> {
    public Request<DescribeScalingActivitiesRequest> marshall(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        if (describeScalingActivitiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeScalingActivitiesRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeScalingActivities");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> activityIdsList = describeScalingActivitiesRequest.activityIds();
        if (activityIdsList != null) {
            if (!activityIdsList.isEmpty()) {
                int activityIdsListIndex = 1;
                for (String activityIdsListValue : activityIdsList) {
                    if (activityIdsListValue != null) {
                        request.addParameter("ActivityIds.member." + activityIdsListIndex, StringUtils.fromString((String)activityIdsListValue));
                    }
                    ++activityIdsListIndex;
                }
            } else {
                request.addParameter("ActivityIds", "");
            }
        }
        if (describeScalingActivitiesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)describeScalingActivitiesRequest.autoScalingGroupName()));
        }
        if (describeScalingActivitiesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeScalingActivitiesRequest.maxRecords()));
        }
        if (describeScalingActivitiesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeScalingActivitiesRequest.nextToken()));
        }
        return request;
    }
}

