/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.ActivitiesCopier;
import software.amazon.awssdk.services.autoscaling.model.Activity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScalingActivitiesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
    private final List<Activity> activities;
    private final String nextToken;

    private DescribeScalingActivitiesResponse(BuilderImpl builder) {
        this.activities = builder.activities;
        this.nextToken = builder.nextToken;
    }

    public List<Activity> activities() {
        return this.activities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.activities() == null ? 0 : this.activities().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesResponse)) {
            return false;
        }
        DescribeScalingActivitiesResponse other = (DescribeScalingActivitiesResponse)((Object)obj);
        if (other.activities() == null ^ this.activities() == null) {
            return false;
        }
        if (other.activities() != null && !other.activities().equals(this.activities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activities() != null) {
            sb.append("Activities: ").append(this.activities()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Activity> activities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesResponse model) {
            this.setActivities(model.activities);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Activity> getActivities() {
            return this.activities;
        }

        @Override
        public final Builder activities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Activity ... activities) {
            this.activities(Arrays.asList(activities));
            return this;
        }

        public final void setActivities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeScalingActivitiesResponse build() {
            return new DescribeScalingActivitiesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
        public Builder activities(Collection<Activity> var1);

        public Builder activities(Activity ... var1);

        public Builder nextToken(String var1);
    }
}

