/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingNotificationTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAutoScalingNotificationTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAutoScalingNotificationTypesResponse> {
    private final List<String> autoScalingNotificationTypes;

    private DescribeAutoScalingNotificationTypesResponse(BuilderImpl builder) {
        this.autoScalingNotificationTypes = builder.autoScalingNotificationTypes;
    }

    public List<String> autoScalingNotificationTypes() {
        return this.autoScalingNotificationTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingNotificationTypes() == null ? 0 : this.autoScalingNotificationTypes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingNotificationTypesResponse)) {
            return false;
        }
        DescribeAutoScalingNotificationTypesResponse other = (DescribeAutoScalingNotificationTypesResponse)((Object)obj);
        if (other.autoScalingNotificationTypes() == null ^ this.autoScalingNotificationTypes() == null) {
            return false;
        }
        return other.autoScalingNotificationTypes() == null || other.autoScalingNotificationTypes().equals(this.autoScalingNotificationTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingNotificationTypes() != null) {
            sb.append("AutoScalingNotificationTypes: ").append(this.autoScalingNotificationTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> autoScalingNotificationTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingNotificationTypesResponse model) {
            this.setAutoScalingNotificationTypes(model.autoScalingNotificationTypes);
        }

        public final Collection<String> getAutoScalingNotificationTypes() {
            return this.autoScalingNotificationTypes;
        }

        @Override
        public final Builder autoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes = AutoScalingNotificationTypesCopier.copy(autoScalingNotificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingNotificationTypes(String ... autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes(Arrays.asList(autoScalingNotificationTypes));
            return this;
        }

        public final void setAutoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes = AutoScalingNotificationTypesCopier.copy(autoScalingNotificationTypes);
        }

        public DescribeAutoScalingNotificationTypesResponse build() {
            return new DescribeAutoScalingNotificationTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAutoScalingNotificationTypesResponse> {
        public Builder autoScalingNotificationTypes(Collection<String> var1);

        public Builder autoScalingNotificationTypes(String ... var1);
    }
}

