/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeLaunchConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeLaunchConfigurationsRequest>, DescribeLaunchConfigurationsRequest> {
    public Request<DescribeLaunchConfigurationsRequest> marshall(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        if (describeLaunchConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLaunchConfigurationsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeLaunchConfigurations");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> launchConfigurationNamesList = describeLaunchConfigurationsRequest.launchConfigurationNames();
        if (launchConfigurationNamesList != null) {
            if (!launchConfigurationNamesList.isEmpty()) {
                int launchConfigurationNamesListIndex = 1;
                for (String launchConfigurationNamesListValue : launchConfigurationNamesList) {
                    if (launchConfigurationNamesListValue != null) {
                        request.addParameter("LaunchConfigurationNames.member." + launchConfigurationNamesListIndex, StringUtils.fromString((String)launchConfigurationNamesListValue));
                    }
                    ++launchConfigurationNamesListIndex;
                }
            } else {
                request.addParameter("LaunchConfigurationNames", "");
            }
        }
        if (describeLaunchConfigurationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeLaunchConfigurationsRequest.nextToken()));
        }
        if (describeLaunchConfigurationsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeLaunchConfigurationsRequest.maxRecords()));
        }
        return request;
    }
}

