/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetInstanceHealthRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetInstanceHealthRequest> {
    private final String instanceId;
    private final String healthStatus;
    private final Boolean shouldRespectGracePeriod;

    private SetInstanceHealthRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.healthStatus = builder.healthStatus;
        this.shouldRespectGracePeriod = builder.shouldRespectGracePeriod;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String healthStatus() {
        return this.healthStatus;
    }

    public Boolean shouldRespectGracePeriod() {
        return this.shouldRespectGracePeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.healthStatus() == null ? 0 : this.healthStatus().hashCode());
        hashCode = 31 * hashCode + (this.shouldRespectGracePeriod() == null ? 0 : this.shouldRespectGracePeriod().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetInstanceHealthRequest)) {
            return false;
        }
        SetInstanceHealthRequest other = (SetInstanceHealthRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.healthStatus() == null ^ this.healthStatus() == null) {
            return false;
        }
        if (other.healthStatus() != null && !other.healthStatus().equals(this.healthStatus())) {
            return false;
        }
        if (other.shouldRespectGracePeriod() == null ^ this.shouldRespectGracePeriod() == null) {
            return false;
        }
        return other.shouldRespectGracePeriod() == null || other.shouldRespectGracePeriod().equals(this.shouldRespectGracePeriod());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.healthStatus() != null) {
            sb.append("HealthStatus: ").append(this.healthStatus()).append(",");
        }
        if (this.shouldRespectGracePeriod() != null) {
            sb.append("ShouldRespectGracePeriod: ").append(this.shouldRespectGracePeriod()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String healthStatus;
        private Boolean shouldRespectGracePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SetInstanceHealthRequest model) {
            this.setInstanceId(model.instanceId);
            this.setHealthStatus(model.healthStatus);
            this.setShouldRespectGracePeriod(model.shouldRespectGracePeriod);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final Boolean getShouldRespectGracePeriod() {
            return this.shouldRespectGracePeriod;
        }

        @Override
        public final Builder shouldRespectGracePeriod(Boolean shouldRespectGracePeriod) {
            this.shouldRespectGracePeriod = shouldRespectGracePeriod;
            return this;
        }

        public final void setShouldRespectGracePeriod(Boolean shouldRespectGracePeriod) {
            this.shouldRespectGracePeriod = shouldRespectGracePeriod;
        }

        public SetInstanceHealthRequest build() {
            return new SetInstanceHealthRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetInstanceHealthRequest> {
        public Builder instanceId(String var1);

        public Builder healthStatus(String var1);

        public Builder shouldRespectGracePeriod(Boolean var1);
    }
}

