/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExecutePolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ExecutePolicyRequest> {
    private final String autoScalingGroupName;
    private final String policyName;
    private final Boolean honorCooldown;
    private final Double metricValue;
    private final Double breachThreshold;

    private ExecutePolicyRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.honorCooldown = builder.honorCooldown;
        this.metricValue = builder.metricValue;
        this.breachThreshold = builder.breachThreshold;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String policyName() {
        return this.policyName;
    }

    public Boolean honorCooldown() {
        return this.honorCooldown;
    }

    public Double metricValue() {
        return this.metricValue;
    }

    public Double breachThreshold() {
        return this.breachThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        hashCode = 31 * hashCode + (this.honorCooldown() == null ? 0 : this.honorCooldown().hashCode());
        hashCode = 31 * hashCode + (this.metricValue() == null ? 0 : this.metricValue().hashCode());
        hashCode = 31 * hashCode + (this.breachThreshold() == null ? 0 : this.breachThreshold().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutePolicyRequest)) {
            return false;
        }
        ExecutePolicyRequest other = (ExecutePolicyRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.honorCooldown() == null ^ this.honorCooldown() == null) {
            return false;
        }
        if (other.honorCooldown() != null && !other.honorCooldown().equals(this.honorCooldown())) {
            return false;
        }
        if (other.metricValue() == null ^ this.metricValue() == null) {
            return false;
        }
        if (other.metricValue() != null && !other.metricValue().equals(this.metricValue())) {
            return false;
        }
        if (other.breachThreshold() == null ^ this.breachThreshold() == null) {
            return false;
        }
        return other.breachThreshold() == null || other.breachThreshold().equals(this.breachThreshold());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.honorCooldown() != null) {
            sb.append("HonorCooldown: ").append(this.honorCooldown()).append(",");
        }
        if (this.metricValue() != null) {
            sb.append("MetricValue: ").append(this.metricValue()).append(",");
        }
        if (this.breachThreshold() != null) {
            sb.append("BreachThreshold: ").append(this.breachThreshold()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String policyName;
        private Boolean honorCooldown;
        private Double metricValue;
        private Double breachThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutePolicyRequest model) {
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setPolicyName(model.policyName);
            this.setHonorCooldown(model.honorCooldown);
            this.setMetricValue(model.metricValue);
            this.setBreachThreshold(model.breachThreshold);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final Boolean getHonorCooldown() {
            return this.honorCooldown;
        }

        @Override
        public final Builder honorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
            return this;
        }

        public final void setHonorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
        }

        public final Double getMetricValue() {
            return this.metricValue;
        }

        @Override
        public final Builder metricValue(Double metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(Double metricValue) {
            this.metricValue = metricValue;
        }

        public final Double getBreachThreshold() {
            return this.breachThreshold;
        }

        @Override
        public final Builder breachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
            return this;
        }

        public final void setBreachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
        }

        public ExecutePolicyRequest build() {
            return new ExecutePolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExecutePolicyRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder policyName(String var1);

        public Builder honorCooldown(Boolean var1);

        public Builder metricValue(Double var1);

        public Builder breachThreshold(Double var1);
    }
}

