/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest;
import software.amazon.awssdk.util.StringUtils;

public class EnterStandbyRequestMarshaller
implements Marshaller<Request<EnterStandbyRequest>, EnterStandbyRequest> {
    public Request<EnterStandbyRequest> marshall(EnterStandbyRequest enterStandbyRequest) {
        if (enterStandbyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enterStandbyRequest, "AutoScalingClient");
        request.addParameter("Action", "EnterStandby");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> instanceIdsList = enterStandbyRequest.instanceIds();
        if (instanceIdsList != null) {
            if (!instanceIdsList.isEmpty()) {
                int instanceIdsListIndex = 1;
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue != null) {
                        request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString((String)instanceIdsListValue));
                    }
                    ++instanceIdsListIndex;
                }
            } else {
                request.addParameter("InstanceIds", "");
            }
        }
        if (enterStandbyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)enterStandbyRequest.autoScalingGroupName()));
        }
        if (enterStandbyRequest.shouldDecrementDesiredCapacity() != null) {
            request.addParameter("ShouldDecrementDesiredCapacity", StringUtils.fromBoolean((Boolean)enterStandbyRequest.shouldDecrementDesiredCapacity()));
        }
        return request;
    }
}

