/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerTargetGroupState;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerTargetGroupStatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancerTargetGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLoadBalancerTargetGroupsResponse> {
    private final List<LoadBalancerTargetGroupState> loadBalancerTargetGroups;
    private final String nextToken;

    private DescribeLoadBalancerTargetGroupsResponse(BuilderImpl builder) {
        this.loadBalancerTargetGroups = builder.loadBalancerTargetGroups;
        this.nextToken = builder.nextToken;
    }

    public List<LoadBalancerTargetGroupState> loadBalancerTargetGroups() {
        return this.loadBalancerTargetGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerTargetGroups() == null ? 0 : this.loadBalancerTargetGroups().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerTargetGroupsResponse)) {
            return false;
        }
        DescribeLoadBalancerTargetGroupsResponse other = (DescribeLoadBalancerTargetGroupsResponse)((Object)obj);
        if (other.loadBalancerTargetGroups() == null ^ this.loadBalancerTargetGroups() == null) {
            return false;
        }
        if (other.loadBalancerTargetGroups() != null && !other.loadBalancerTargetGroups().equals(this.loadBalancerTargetGroups())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerTargetGroups() != null) {
            sb.append("LoadBalancerTargetGroups: ").append(this.loadBalancerTargetGroups()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LoadBalancerTargetGroupState> loadBalancerTargetGroups;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerTargetGroupsResponse model) {
            this.setLoadBalancerTargetGroups(model.loadBalancerTargetGroups);
            this.setNextToken(model.nextToken);
        }

        public final Collection<LoadBalancerTargetGroupState> getLoadBalancerTargetGroups() {
            return this.loadBalancerTargetGroups;
        }

        @Override
        public final Builder loadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = LoadBalancerTargetGroupStatesCopier.copy(loadBalancerTargetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(LoadBalancerTargetGroupState ... loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups(Arrays.asList(loadBalancerTargetGroups));
            return this;
        }

        public final void setLoadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = LoadBalancerTargetGroupStatesCopier.copy(loadBalancerTargetGroups);
        }

        @SafeVarargs
        public final void setLoadBalancerTargetGroups(LoadBalancerTargetGroupState ... loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups(Arrays.asList(loadBalancerTargetGroups));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeLoadBalancerTargetGroupsResponse build() {
            return new DescribeLoadBalancerTargetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancerTargetGroupsResponse> {
        public Builder loadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> var1);

        public Builder loadBalancerTargetGroups(LoadBalancerTargetGroupState ... var1);

        public Builder nextToken(String var1);
    }
}

