/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;

public class DescribeScheduledActionsRequestMarshaller
implements Marshaller<Request<DescribeScheduledActionsRequest>, DescribeScheduledActionsRequest> {
    public Request<DescribeScheduledActionsRequest> marshall(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        List<String> scheduledActionNamesList;
        if (describeScheduledActionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeScheduledActionsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeScheduledActions");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeScheduledActionsRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)describeScheduledActionsRequest.autoScalingGroupName()));
        }
        if ((scheduledActionNamesList = describeScheduledActionsRequest.scheduledActionNames()) != null) {
            if (!scheduledActionNamesList.isEmpty()) {
                int scheduledActionNamesListIndex = 1;
                for (String scheduledActionNamesListValue : scheduledActionNamesList) {
                    if (scheduledActionNamesListValue != null) {
                        request.addParameter("ScheduledActionNames.member." + scheduledActionNamesListIndex, StringUtils.fromString((String)scheduledActionNamesListValue));
                    }
                    ++scheduledActionNamesListIndex;
                }
            } else {
                request.addParameter("ScheduledActionNames", "");
            }
        }
        if (describeScheduledActionsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant((Instant)describeScheduledActionsRequest.startTime()));
        }
        if (describeScheduledActionsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant((Instant)describeScheduledActionsRequest.endTime()));
        }
        if (describeScheduledActionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeScheduledActionsRequest.nextToken()));
        }
        if (describeScheduledActionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeScheduledActionsRequest.maxRecords()));
        }
        return request;
    }
}

