/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;

public class DescribeAutoScalingGroupsRequestMarshaller
implements Marshaller<Request<DescribeAutoScalingGroupsRequest>, DescribeAutoScalingGroupsRequest> {
    public Request<DescribeAutoScalingGroupsRequest> marshall(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        if (describeAutoScalingGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeAutoScalingGroupsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeAutoScalingGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> autoScalingGroupNamesList = describeAutoScalingGroupsRequest.autoScalingGroupNames();
        if (autoScalingGroupNamesList != null) {
            if (!autoScalingGroupNamesList.isEmpty()) {
                int autoScalingGroupNamesListIndex = 1;
                for (String autoScalingGroupNamesListValue : autoScalingGroupNamesList) {
                    if (autoScalingGroupNamesListValue != null) {
                        request.addParameter("AutoScalingGroupNames.member." + autoScalingGroupNamesListIndex, StringUtils.fromString((String)autoScalingGroupNamesListValue));
                    }
                    ++autoScalingGroupNamesListIndex;
                }
            } else {
                request.addParameter("AutoScalingGroupNames", "");
            }
        }
        if (describeAutoScalingGroupsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAutoScalingGroupsRequest.nextToken()));
        }
        if (describeAutoScalingGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAutoScalingGroupsRequest.maxRecords()));
        }
        return request;
    }
}

