/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.MetricCollectionType;
import software.amazon.awssdk.services.autoscaling.model.MetricCollectionTypesCopier;
import software.amazon.awssdk.services.autoscaling.model.MetricGranularityType;
import software.amazon.awssdk.services.autoscaling.model.MetricGranularityTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMetricCollectionTypesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeMetricCollectionTypesResponse> {
    private final List<MetricCollectionType> metrics;
    private final List<MetricGranularityType> granularities;

    private DescribeMetricCollectionTypesResponse(BuilderImpl builder) {
        super(builder);
        this.metrics = builder.metrics;
        this.granularities = builder.granularities;
    }

    public List<MetricCollectionType> metrics() {
        return this.metrics;
    }

    public List<MetricGranularityType> granularities() {
        return this.granularities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.granularities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricCollectionTypesResponse)) {
            return false;
        }
        DescribeMetricCollectionTypesResponse other = (DescribeMetricCollectionTypesResponse)((Object)obj);
        return Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.granularities(), other.granularities());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMetricCollectionTypesResponse").add("Metrics", this.metrics()).add("Granularities", this.granularities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metrics": {
                return Optional.of(clazz.cast(this.metrics()));
            }
            case "Granularities": {
                return Optional.of(clazz.cast(this.granularities()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<MetricCollectionType> metrics;
        private List<MetricGranularityType> granularities;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricCollectionTypesResponse model) {
            super(model);
            this.metrics(model.metrics);
            this.granularities(model.granularities);
        }

        public final Collection<MetricCollectionType.Builder> getMetrics() {
            return this.metrics != null ? (Collection)this.metrics.stream().map(MetricCollectionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metrics(Collection<MetricCollectionType> metrics) {
            this.metrics = MetricCollectionTypesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricCollectionType ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<MetricCollectionType.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (MetricCollectionType)((MetricCollectionType.Builder)MetricCollectionType.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetrics(Collection<MetricCollectionType.BuilderImpl> metrics) {
            this.metrics = MetricCollectionTypesCopier.copyFromBuilder(metrics);
        }

        public final Collection<MetricGranularityType.Builder> getGranularities() {
            return this.granularities != null ? (Collection)this.granularities.stream().map(MetricGranularityType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder granularities(Collection<MetricGranularityType> granularities) {
            this.granularities = MetricGranularityTypesCopier.copy(granularities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder granularities(MetricGranularityType ... granularities) {
            this.granularities(Arrays.asList(granularities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder granularities(Consumer<MetricGranularityType.Builder> ... granularities) {
            this.granularities(Stream.of(granularities).map(c -> (MetricGranularityType)((MetricGranularityType.Builder)MetricGranularityType.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGranularities(Collection<MetricGranularityType.BuilderImpl> granularities) {
            this.granularities = MetricGranularityTypesCopier.copyFromBuilder(granularities);
        }

        @Override
        public DescribeMetricCollectionTypesResponse build() {
            return new DescribeMetricCollectionTypesResponse(this);
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    CopyableBuilder<Builder, DescribeMetricCollectionTypesResponse> {
        public Builder metrics(Collection<MetricCollectionType> var1);

        public Builder metrics(MetricCollectionType ... var1);

        public Builder metrics(Consumer<MetricCollectionType.Builder> ... var1);

        public Builder granularities(Collection<MetricGranularityType> var1);

        public Builder granularities(MetricGranularityType ... var1);

        public Builder granularities(Consumer<MetricGranularityType.Builder> ... var1);
    }
}

