/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingInstanceDetails;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingInstancesCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAutoScalingInstancesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeAutoScalingInstancesResponse> {
    private final List<AutoScalingInstanceDetails> autoScalingInstances;
    private final String nextToken;

    private DescribeAutoScalingInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.autoScalingInstances = builder.autoScalingInstances;
        this.nextToken = builder.nextToken;
    }

    public List<AutoScalingInstanceDetails> autoScalingInstances() {
        return this.autoScalingInstances;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingInstancesResponse)) {
            return false;
        }
        DescribeAutoScalingInstancesResponse other = (DescribeAutoScalingInstancesResponse)((Object)obj);
        return Objects.equals(this.autoScalingInstances(), other.autoScalingInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAutoScalingInstancesResponse").add("AutoScalingInstances", this.autoScalingInstances()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingInstances": {
                return Optional.of(clazz.cast(this.autoScalingInstances()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<AutoScalingInstanceDetails> autoScalingInstances;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingInstancesResponse model) {
            super(model);
            this.autoScalingInstances(model.autoScalingInstances);
            this.nextToken(model.nextToken);
        }

        public final Collection<AutoScalingInstanceDetails.Builder> getAutoScalingInstances() {
            return this.autoScalingInstances != null ? (Collection)this.autoScalingInstances.stream().map(AutoScalingInstanceDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoScalingInstances(Collection<AutoScalingInstanceDetails> autoScalingInstances) {
            this.autoScalingInstances = AutoScalingInstancesCopier.copy(autoScalingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingInstances(AutoScalingInstanceDetails ... autoScalingInstances) {
            this.autoScalingInstances(Arrays.asList(autoScalingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingInstances(Consumer<AutoScalingInstanceDetails.Builder> ... autoScalingInstances) {
            this.autoScalingInstances(Stream.of(autoScalingInstances).map(c -> (AutoScalingInstanceDetails)((AutoScalingInstanceDetails.Builder)AutoScalingInstanceDetails.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutoScalingInstances(Collection<AutoScalingInstanceDetails.BuilderImpl> autoScalingInstances) {
            this.autoScalingInstances = AutoScalingInstancesCopier.copyFromBuilder(autoScalingInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAutoScalingInstancesResponse build() {
            return new DescribeAutoScalingInstancesResponse(this);
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    CopyableBuilder<Builder, DescribeAutoScalingInstancesResponse> {
        public Builder autoScalingInstances(Collection<AutoScalingInstanceDetails> var1);

        public Builder autoScalingInstances(AutoScalingInstanceDetails ... var1);

        public Builder autoScalingInstances(Consumer<AutoScalingInstanceDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

