/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.autoscaling.model.AdjustmentType;
import software.amazon.awssdk.services.autoscaling.model.AdjustmentTypesCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAdjustmentTypesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeAdjustmentTypesResponse> {
    private final List<AdjustmentType> adjustmentTypes;

    private DescribeAdjustmentTypesResponse(BuilderImpl builder) {
        super(builder);
        this.adjustmentTypes = builder.adjustmentTypes;
    }

    public List<AdjustmentType> adjustmentTypes() {
        return this.adjustmentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adjustmentTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAdjustmentTypesResponse)) {
            return false;
        }
        DescribeAdjustmentTypesResponse other = (DescribeAdjustmentTypesResponse)((Object)obj);
        return Objects.equals(this.adjustmentTypes(), other.adjustmentTypes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAdjustmentTypesResponse").add("AdjustmentTypes", this.adjustmentTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdjustmentTypes": {
                return Optional.of(clazz.cast(this.adjustmentTypes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<AdjustmentType> adjustmentTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAdjustmentTypesResponse model) {
            super(model);
            this.adjustmentTypes(model.adjustmentTypes);
        }

        public final Collection<AdjustmentType.Builder> getAdjustmentTypes() {
            return this.adjustmentTypes != null ? (Collection)this.adjustmentTypes.stream().map(AdjustmentType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder adjustmentTypes(Collection<AdjustmentType> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copy(adjustmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustmentTypes(AdjustmentType ... adjustmentTypes) {
            this.adjustmentTypes(Arrays.asList(adjustmentTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustmentTypes(Consumer<AdjustmentType.Builder> ... adjustmentTypes) {
            this.adjustmentTypes(Stream.of(adjustmentTypes).map(c -> (AdjustmentType)((AdjustmentType.Builder)AdjustmentType.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdjustmentTypes(Collection<AdjustmentType.BuilderImpl> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copyFromBuilder(adjustmentTypes);
        }

        @Override
        public DescribeAdjustmentTypesResponse build() {
            return new DescribeAdjustmentTypesResponse(this);
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    CopyableBuilder<Builder, DescribeAdjustmentTypesResponse> {
        public Builder adjustmentTypes(Collection<AdjustmentType> var1);

        public Builder adjustmentTypes(AdjustmentType ... var1);

        public Builder adjustmentTypes(Consumer<AdjustmentType.Builder> ... var1);
    }
}

